package zio.aws.ssm.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import zio.aws.ssm.model.primitives.{
  NextToken,
  DescribeInstancePropertiesMaxResults
}
import scala.jdk.CollectionConverters.*
final case class DescribeInstancePropertiesRequest(
    instancePropertyFilterList: Optional[
      Iterable[zio.aws.ssm.model.InstancePropertyFilter]
    ] = Optional.Absent,
    filtersWithOperator: Optional[
      Iterable[zio.aws.ssm.model.InstancePropertyStringFilter]
    ] = Optional.Absent,
    maxResults: Optional[DescribeInstancePropertiesMaxResults] =
      Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ssm.model.DescribeInstancePropertiesRequest = {
    import DescribeInstancePropertiesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ssm.model.DescribeInstancePropertiesRequest
      .builder()
      .optionallyWith(
        instancePropertyFilterList.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.instancePropertyFilterList)
      .optionallyWith(
        filtersWithOperator.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.filtersWithOperator)
      .optionallyWith(
        maxResults.map(value =>
          DescribeInstancePropertiesMaxResults.unwrap(value): Integer
        )
      )(_.maxResults)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.ssm.model.DescribeInstancePropertiesRequest.ReadOnly =
    zio.aws.ssm.model.DescribeInstancePropertiesRequest.wrap(buildAwsValue())
}
object DescribeInstancePropertiesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ssm.model.DescribeInstancePropertiesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ssm.model.DescribeInstancePropertiesRequest =
      zio.aws.ssm.model.DescribeInstancePropertiesRequest(
        instancePropertyFilterList.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        filtersWithOperator.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        maxResults.map(value => value),
        nextToken.map(value => value)
      )
    def instancePropertyFilterList
        : Optional[List[zio.aws.ssm.model.InstancePropertyFilter.ReadOnly]]
    def filtersWithOperator: Optional[
      List[zio.aws.ssm.model.InstancePropertyStringFilter.ReadOnly]
    ]
    def maxResults: Optional[DescribeInstancePropertiesMaxResults]
    def nextToken: Optional[NextToken]
    def getInstancePropertyFilterList: ZIO[Any, AwsError, List[
      zio.aws.ssm.model.InstancePropertyFilter.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "instancePropertyFilterList",
      instancePropertyFilterList
    )
    def getFiltersWithOperator: ZIO[Any, AwsError, List[
      zio.aws.ssm.model.InstancePropertyStringFilter.ReadOnly
    ]] = AwsError.unwrapOptionField("filtersWithOperator", filtersWithOperator)
    def getMaxResults
        : ZIO[Any, AwsError, DescribeInstancePropertiesMaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ssm.model.DescribeInstancePropertiesRequest
  ) extends zio.aws.ssm.model.DescribeInstancePropertiesRequest.ReadOnly {
    override val instancePropertyFilterList
        : Optional[List[zio.aws.ssm.model.InstancePropertyFilter.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.instancePropertyFilterList())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ssm.model.InstancePropertyFilter.wrap(item)
          }.toList
        )
    override val filtersWithOperator: Optional[
      List[zio.aws.ssm.model.InstancePropertyStringFilter.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.filtersWithOperator())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ssm.model.InstancePropertyStringFilter.wrap(item)
        }.toList
      )
    override val maxResults: Optional[DescribeInstancePropertiesMaxResults] =
      zio.aws.core.internal
        .optionalFromNullable(impl.maxResults())
        .map(value =>
          zio.aws.ssm.model.primitives
            .DescribeInstancePropertiesMaxResults(value)
        )
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.ssm.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ssm.model.DescribeInstancePropertiesRequest
  ): zio.aws.ssm.model.DescribeInstancePropertiesRequest.ReadOnly = new Wrapper(
    impl
  )
}
