package zio.aws.ssm.model
import zio.aws.ssm.model.primitives.NextToken
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class DescribeInstancePropertiesResponse(
    instanceProperties: Optional[Iterable[zio.aws.ssm.model.InstanceProperty]] =
      Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ssm.model.DescribeInstancePropertiesResponse = {
    import DescribeInstancePropertiesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ssm.model.DescribeInstancePropertiesResponse
      .builder()
      .optionallyWith(
        instanceProperties.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.instanceProperties)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.ssm.model.DescribeInstancePropertiesResponse.ReadOnly =
    zio.aws.ssm.model.DescribeInstancePropertiesResponse.wrap(buildAwsValue())
}
object DescribeInstancePropertiesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ssm.model.DescribeInstancePropertiesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ssm.model.DescribeInstancePropertiesResponse =
      zio.aws.ssm.model.DescribeInstancePropertiesResponse(
        instanceProperties.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def instanceProperties
        : Optional[List[zio.aws.ssm.model.InstanceProperty.ReadOnly]]
    def nextToken: Optional[NextToken]
    def getInstanceProperties: ZIO[Any, AwsError, List[
      zio.aws.ssm.model.InstanceProperty.ReadOnly
    ]] = AwsError.unwrapOptionField("instanceProperties", instanceProperties)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ssm.model.DescribeInstancePropertiesResponse
  ) extends zio.aws.ssm.model.DescribeInstancePropertiesResponse.ReadOnly {
    override val instanceProperties
        : Optional[List[zio.aws.ssm.model.InstanceProperty.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.instanceProperties())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ssm.model.InstanceProperty.wrap(item)
          }.toList
        )
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.ssm.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ssm.model.DescribeInstancePropertiesResponse
  ): zio.aws.ssm.model.DescribeInstancePropertiesResponse.ReadOnly =
    new Wrapper(impl)
}
