package zio.aws.ssm.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import zio.aws.ssm.model.primitives.{
  NextToken,
  MaintenanceWindowMaxResults,
  MaintenanceWindowExecutionTaskId,
  MaintenanceWindowExecutionId
}
import scala.jdk.CollectionConverters.*
final case class DescribeMaintenanceWindowExecutionTaskInvocationsRequest(
    windowExecutionId: MaintenanceWindowExecutionId,
    taskId: MaintenanceWindowExecutionTaskId,
    filters: Optional[Iterable[zio.aws.ssm.model.MaintenanceWindowFilter]] =
      Optional.Absent,
    maxResults: Optional[MaintenanceWindowMaxResults] = Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ssm.model.DescribeMaintenanceWindowExecutionTaskInvocationsRequest = {
    import DescribeMaintenanceWindowExecutionTaskInvocationsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ssm.model.DescribeMaintenanceWindowExecutionTaskInvocationsRequest
      .builder()
      .windowExecutionId(
        MaintenanceWindowExecutionId.unwrap(windowExecutionId): java.lang.String
      )
      .taskId(MaintenanceWindowExecutionTaskId.unwrap(taskId): java.lang.String)
      .optionallyWith(
        filters.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.filters)
      .optionallyWith(
        maxResults.map(value =>
          MaintenanceWindowMaxResults.unwrap(value): Integer
        )
      )(_.maxResults)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.ssm.model.DescribeMaintenanceWindowExecutionTaskInvocationsRequest.ReadOnly =
    zio.aws.ssm.model.DescribeMaintenanceWindowExecutionTaskInvocationsRequest
      .wrap(buildAwsValue())
}
object DescribeMaintenanceWindowExecutionTaskInvocationsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ssm.model.DescribeMaintenanceWindowExecutionTaskInvocationsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.ssm.model.DescribeMaintenanceWindowExecutionTaskInvocationsRequest =
      zio.aws.ssm.model
        .DescribeMaintenanceWindowExecutionTaskInvocationsRequest(
          windowExecutionId,
          taskId,
          filters.map(value =>
            value.map { item =>
              item.asEditable
            }
          ),
          maxResults.map(value => value),
          nextToken.map(value => value)
        )
    def windowExecutionId: MaintenanceWindowExecutionId
    def taskId: MaintenanceWindowExecutionTaskId
    def filters
        : Optional[List[zio.aws.ssm.model.MaintenanceWindowFilter.ReadOnly]]
    def maxResults: Optional[MaintenanceWindowMaxResults]
    def nextToken: Optional[NextToken]
    def getWindowExecutionId: ZIO[Any, Nothing, MaintenanceWindowExecutionId] =
      ZIO.succeed(windowExecutionId)
    def getTaskId: ZIO[Any, Nothing, MaintenanceWindowExecutionTaskId] =
      ZIO.succeed(taskId)
    def getFilters: ZIO[Any, AwsError, List[
      zio.aws.ssm.model.MaintenanceWindowFilter.ReadOnly
    ]] = AwsError.unwrapOptionField("filters", filters)
    def getMaxResults: ZIO[Any, AwsError, MaintenanceWindowMaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ssm.model.DescribeMaintenanceWindowExecutionTaskInvocationsRequest
  ) extends zio.aws.ssm.model.DescribeMaintenanceWindowExecutionTaskInvocationsRequest.ReadOnly {
    override val windowExecutionId: MaintenanceWindowExecutionId =
      zio.aws.ssm.model.primitives
        .MaintenanceWindowExecutionId(impl.windowExecutionId())
    override val taskId: MaintenanceWindowExecutionTaskId =
      zio.aws.ssm.model.primitives
        .MaintenanceWindowExecutionTaskId(impl.taskId())
    override val filters
        : Optional[List[zio.aws.ssm.model.MaintenanceWindowFilter.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.filters())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ssm.model.MaintenanceWindowFilter.wrap(item)
          }.toList
        )
    override val maxResults: Optional[MaintenanceWindowMaxResults] =
      zio.aws.core.internal
        .optionalFromNullable(impl.maxResults())
        .map(value =>
          zio.aws.ssm.model.primitives.MaintenanceWindowMaxResults(value)
        )
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.ssm.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ssm.model.DescribeMaintenanceWindowExecutionTaskInvocationsRequest
  ): zio.aws.ssm.model.DescribeMaintenanceWindowExecutionTaskInvocationsRequest.ReadOnly =
    new Wrapper(impl)
}
