package zio.aws.ssm.model
import zio.aws.ssm.model.primitives.{OpsItemRelatedItemAssociationId, OpsItemId}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class DisassociateOpsItemRelatedItemRequest(
    opsItemId: OpsItemId,
    associationId: OpsItemRelatedItemAssociationId
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ssm.model.DisassociateOpsItemRelatedItemRequest = {
    import DisassociateOpsItemRelatedItemRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ssm.model.DisassociateOpsItemRelatedItemRequest
      .builder()
      .opsItemId(OpsItemId.unwrap(opsItemId): java.lang.String)
      .associationId(
        OpsItemRelatedItemAssociationId.unwrap(associationId): java.lang.String
      )
      .build()
  }
  def asReadOnly
      : zio.aws.ssm.model.DisassociateOpsItemRelatedItemRequest.ReadOnly =
    zio.aws.ssm.model.DisassociateOpsItemRelatedItemRequest
      .wrap(buildAwsValue())
}
object DisassociateOpsItemRelatedItemRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ssm.model.DisassociateOpsItemRelatedItemRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ssm.model.DisassociateOpsItemRelatedItemRequest =
      zio.aws.ssm.model
        .DisassociateOpsItemRelatedItemRequest(opsItemId, associationId)
    def opsItemId: OpsItemId
    def associationId: OpsItemRelatedItemAssociationId
    def getOpsItemId: ZIO[Any, Nothing, OpsItemId] = ZIO.succeed(opsItemId)
    def getAssociationId: ZIO[Any, Nothing, OpsItemRelatedItemAssociationId] =
      ZIO.succeed(associationId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ssm.model.DisassociateOpsItemRelatedItemRequest
  ) extends zio.aws.ssm.model.DisassociateOpsItemRelatedItemRequest.ReadOnly {
    override val opsItemId: OpsItemId =
      zio.aws.ssm.model.primitives.OpsItemId(impl.opsItemId())
    override val associationId: OpsItemRelatedItemAssociationId =
      zio.aws.ssm.model.primitives
        .OpsItemRelatedItemAssociationId(impl.associationId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.ssm.model.DisassociateOpsItemRelatedItemRequest
  ): zio.aws.ssm.model.DisassociateOpsItemRelatedItemRequest.ReadOnly =
    new Wrapper(impl)
}
