package zio.aws.ssm.model
import scala.jdk.CollectionConverters.*
sealed trait DocumentReviewCommentType {
  def unwrap
      : software.amazon.awssdk.services.ssm.model.DocumentReviewCommentType
}
object DocumentReviewCommentType {
  def wrap(
      value: software.amazon.awssdk.services.ssm.model.DocumentReviewCommentType
  ): zio.aws.ssm.model.DocumentReviewCommentType = value match {
    case software.amazon.awssdk.services.ssm.model.DocumentReviewCommentType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.ssm.model.DocumentReviewCommentType.COMMENT =>
      val r = Comment
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.ssm.model.DocumentReviewCommentType {
    override def unwrap
        : software.amazon.awssdk.services.ssm.model.DocumentReviewCommentType =
      software.amazon.awssdk.services.ssm.model.DocumentReviewCommentType.UNKNOWN_TO_SDK_VERSION
  }
  case object Comment extends zio.aws.ssm.model.DocumentReviewCommentType {
    override def unwrap
        : software.amazon.awssdk.services.ssm.model.DocumentReviewCommentType =
      software.amazon.awssdk.services.ssm.model.DocumentReviewCommentType.COMMENT
  }
}
