package zio.aws.ssm.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.ssm.model.primitives.{
  MaintenanceWindowTaskTargetId,
  MaintenanceWindowExecutionId,
  OwnerInformation,
  MaintenanceWindowExecutionTaskInvocationParameters,
  DateTime,
  MaintenanceWindowExecutionTaskId,
  MaintenanceWindowExecutionTaskExecutionId,
  MaintenanceWindowExecutionTaskInvocationId,
  MaintenanceWindowExecutionStatusDetails
}
import scala.jdk.CollectionConverters.*
final case class GetMaintenanceWindowExecutionTaskInvocationResponse(
    windowExecutionId: Optional[MaintenanceWindowExecutionId] = Optional.Absent,
    taskExecutionId: Optional[MaintenanceWindowExecutionTaskId] =
      Optional.Absent,
    invocationId: Optional[MaintenanceWindowExecutionTaskInvocationId] =
      Optional.Absent,
    executionId: Optional[MaintenanceWindowExecutionTaskExecutionId] =
      Optional.Absent,
    taskType: Optional[zio.aws.ssm.model.MaintenanceWindowTaskType] =
      Optional.Absent,
    parameters: Optional[MaintenanceWindowExecutionTaskInvocationParameters] =
      Optional.Absent,
    status: Optional[zio.aws.ssm.model.MaintenanceWindowExecutionStatus] =
      Optional.Absent,
    statusDetails: Optional[MaintenanceWindowExecutionStatusDetails] =
      Optional.Absent,
    startTime: Optional[DateTime] = Optional.Absent,
    endTime: Optional[DateTime] = Optional.Absent,
    ownerInformation: Optional[OwnerInformation] = Optional.Absent,
    windowTargetId: Optional[MaintenanceWindowTaskTargetId] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ssm.model.GetMaintenanceWindowExecutionTaskInvocationResponse = {
    import GetMaintenanceWindowExecutionTaskInvocationResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ssm.model.GetMaintenanceWindowExecutionTaskInvocationResponse
      .builder()
      .optionallyWith(
        windowExecutionId.map(value =>
          MaintenanceWindowExecutionId.unwrap(value): java.lang.String
        )
      )(_.windowExecutionId)
      .optionallyWith(
        taskExecutionId.map(value =>
          MaintenanceWindowExecutionTaskId.unwrap(value): java.lang.String
        )
      )(_.taskExecutionId)
      .optionallyWith(
        invocationId.map(value =>
          MaintenanceWindowExecutionTaskInvocationId.unwrap(
            value
          ): java.lang.String
        )
      )(_.invocationId)
      .optionallyWith(
        executionId.map(value =>
          MaintenanceWindowExecutionTaskExecutionId.unwrap(
            value
          ): java.lang.String
        )
      )(_.executionId)
      .optionallyWith(taskType.map(value => value.unwrap))(_.taskType)
      .optionallyWith(
        parameters.map(value =>
          MaintenanceWindowExecutionTaskInvocationParameters.unwrap(
            value
          ): java.lang.String
        )
      )(_.parameters)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(
        statusDetails.map(value =>
          MaintenanceWindowExecutionStatusDetails.unwrap(
            value
          ): java.lang.String
        )
      )(_.statusDetails)
      .optionallyWith(startTime.map(value => DateTime.unwrap(value): Instant))(
        _.startTime
      )
      .optionallyWith(endTime.map(value => DateTime.unwrap(value): Instant))(
        _.endTime
      )
      .optionallyWith(
        ownerInformation.map(value =>
          OwnerInformation.unwrap(value): java.lang.String
        )
      )(_.ownerInformation)
      .optionallyWith(
        windowTargetId.map(value =>
          MaintenanceWindowTaskTargetId.unwrap(value): java.lang.String
        )
      )(_.windowTargetId)
      .build()
  }
  def asReadOnly
      : zio.aws.ssm.model.GetMaintenanceWindowExecutionTaskInvocationResponse.ReadOnly =
    zio.aws.ssm.model.GetMaintenanceWindowExecutionTaskInvocationResponse
      .wrap(buildAwsValue())
}
object GetMaintenanceWindowExecutionTaskInvocationResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ssm.model.GetMaintenanceWindowExecutionTaskInvocationResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.ssm.model.GetMaintenanceWindowExecutionTaskInvocationResponse =
      zio.aws.ssm.model.GetMaintenanceWindowExecutionTaskInvocationResponse(
        windowExecutionId.map(value => value),
        taskExecutionId.map(value => value),
        invocationId.map(value => value),
        executionId.map(value => value),
        taskType.map(value => value),
        parameters.map(value => value),
        status.map(value => value),
        statusDetails.map(value => value),
        startTime.map(value => value),
        endTime.map(value => value),
        ownerInformation.map(value => value),
        windowTargetId.map(value => value)
      )
    def windowExecutionId: Optional[MaintenanceWindowExecutionId]
    def taskExecutionId: Optional[MaintenanceWindowExecutionTaskId]
    def invocationId: Optional[MaintenanceWindowExecutionTaskInvocationId]
    def executionId: Optional[MaintenanceWindowExecutionTaskExecutionId]
    def taskType: Optional[zio.aws.ssm.model.MaintenanceWindowTaskType]
    def parameters: Optional[MaintenanceWindowExecutionTaskInvocationParameters]
    def status: Optional[zio.aws.ssm.model.MaintenanceWindowExecutionStatus]
    def statusDetails: Optional[MaintenanceWindowExecutionStatusDetails]
    def startTime: Optional[DateTime]
    def endTime: Optional[DateTime]
    def ownerInformation: Optional[OwnerInformation]
    def windowTargetId: Optional[MaintenanceWindowTaskTargetId]
    def getWindowExecutionId: ZIO[Any, AwsError, MaintenanceWindowExecutionId] =
      AwsError.unwrapOptionField("windowExecutionId", windowExecutionId)
    def getTaskExecutionId
        : ZIO[Any, AwsError, MaintenanceWindowExecutionTaskId] =
      AwsError.unwrapOptionField("taskExecutionId", taskExecutionId)
    def getInvocationId
        : ZIO[Any, AwsError, MaintenanceWindowExecutionTaskInvocationId] =
      AwsError.unwrapOptionField("invocationId", invocationId)
    def getExecutionId
        : ZIO[Any, AwsError, MaintenanceWindowExecutionTaskExecutionId] =
      AwsError.unwrapOptionField("executionId", executionId)
    def getTaskType
        : ZIO[Any, AwsError, zio.aws.ssm.model.MaintenanceWindowTaskType] =
      AwsError.unwrapOptionField("taskType", taskType)
    def getParameters: ZIO[
      Any,
      AwsError,
      MaintenanceWindowExecutionTaskInvocationParameters
    ] = AwsError.unwrapOptionField("parameters", parameters)
    def getStatus: ZIO[
      Any,
      AwsError,
      zio.aws.ssm.model.MaintenanceWindowExecutionStatus
    ] = AwsError.unwrapOptionField("status", status)
    def getStatusDetails
        : ZIO[Any, AwsError, MaintenanceWindowExecutionStatusDetails] =
      AwsError.unwrapOptionField("statusDetails", statusDetails)
    def getStartTime: ZIO[Any, AwsError, DateTime] =
      AwsError.unwrapOptionField("startTime", startTime)
    def getEndTime: ZIO[Any, AwsError, DateTime] =
      AwsError.unwrapOptionField("endTime", endTime)
    def getOwnerInformation: ZIO[Any, AwsError, OwnerInformation] =
      AwsError.unwrapOptionField("ownerInformation", ownerInformation)
    def getWindowTargetId: ZIO[Any, AwsError, MaintenanceWindowTaskTargetId] =
      AwsError.unwrapOptionField("windowTargetId", windowTargetId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ssm.model.GetMaintenanceWindowExecutionTaskInvocationResponse
  ) extends zio.aws.ssm.model.GetMaintenanceWindowExecutionTaskInvocationResponse.ReadOnly {
    override val windowExecutionId: Optional[MaintenanceWindowExecutionId] =
      zio.aws.core.internal
        .optionalFromNullable(impl.windowExecutionId())
        .map(value =>
          zio.aws.ssm.model.primitives.MaintenanceWindowExecutionId(value)
        )
    override val taskExecutionId: Optional[MaintenanceWindowExecutionTaskId] =
      zio.aws.core.internal
        .optionalFromNullable(impl.taskExecutionId())
        .map(value =>
          zio.aws.ssm.model.primitives.MaintenanceWindowExecutionTaskId(value)
        )
    override val invocationId
        : Optional[MaintenanceWindowExecutionTaskInvocationId] =
      zio.aws.core.internal
        .optionalFromNullable(impl.invocationId())
        .map(value =>
          zio.aws.ssm.model.primitives
            .MaintenanceWindowExecutionTaskInvocationId(value)
        )
    override val executionId
        : Optional[MaintenanceWindowExecutionTaskExecutionId] =
      zio.aws.core.internal
        .optionalFromNullable(impl.executionId())
        .map(value =>
          zio.aws.ssm.model.primitives
            .MaintenanceWindowExecutionTaskExecutionId(value)
        )
    override val taskType
        : Optional[zio.aws.ssm.model.MaintenanceWindowTaskType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.taskType())
        .map(value => zio.aws.ssm.model.MaintenanceWindowTaskType.wrap(value))
    override val parameters
        : Optional[MaintenanceWindowExecutionTaskInvocationParameters] =
      zio.aws.core.internal
        .optionalFromNullable(impl.parameters())
        .map(value =>
          zio.aws.ssm.model.primitives
            .MaintenanceWindowExecutionTaskInvocationParameters(value)
        )
    override val status
        : Optional[zio.aws.ssm.model.MaintenanceWindowExecutionStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.status())
        .map(value =>
          zio.aws.ssm.model.MaintenanceWindowExecutionStatus.wrap(value)
        )
    override val statusDetails
        : Optional[MaintenanceWindowExecutionStatusDetails] =
      zio.aws.core.internal
        .optionalFromNullable(impl.statusDetails())
        .map(value =>
          zio.aws.ssm.model.primitives
            .MaintenanceWindowExecutionStatusDetails(value)
        )
    override val startTime: Optional[DateTime] = zio.aws.core.internal
      .optionalFromNullable(impl.startTime())
      .map(value => zio.aws.ssm.model.primitives.DateTime(value))
    override val endTime: Optional[DateTime] = zio.aws.core.internal
      .optionalFromNullable(impl.endTime())
      .map(value => zio.aws.ssm.model.primitives.DateTime(value))
    override val ownerInformation: Optional[OwnerInformation] =
      zio.aws.core.internal
        .optionalFromNullable(impl.ownerInformation())
        .map(value => zio.aws.ssm.model.primitives.OwnerInformation(value))
    override val windowTargetId: Optional[MaintenanceWindowTaskTargetId] =
      zio.aws.core.internal
        .optionalFromNullable(impl.windowTargetId())
        .map(value =>
          zio.aws.ssm.model.primitives.MaintenanceWindowTaskTargetId(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ssm.model.GetMaintenanceWindowExecutionTaskInvocationResponse
  ): zio.aws.ssm.model.GetMaintenanceWindowExecutionTaskInvocationResponse.ReadOnly =
    new Wrapper(impl)
}
