package zio.aws.ssm.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import zio.aws.ssm.model.primitives.{
  ResourcePolicyMaxResults,
  ResourceArnString
}
import scala.jdk.CollectionConverters.*
final case class GetResourcePoliciesRequest(
    resourceArn: ResourceArnString,
    nextToken: Optional[String] = Optional.Absent,
    maxResults: Optional[ResourcePolicyMaxResults] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ssm.model.GetResourcePoliciesRequest = {
    import GetResourcePoliciesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ssm.model.GetResourcePoliciesRequest
      .builder()
      .resourceArn(ResourceArnString.unwrap(resourceArn): java.lang.String)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .optionallyWith(
        maxResults.map(value => ResourcePolicyMaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .build()
  }
  def asReadOnly: zio.aws.ssm.model.GetResourcePoliciesRequest.ReadOnly =
    zio.aws.ssm.model.GetResourcePoliciesRequest.wrap(buildAwsValue())
}
object GetResourcePoliciesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ssm.model.GetResourcePoliciesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ssm.model.GetResourcePoliciesRequest =
      zio.aws.ssm.model.GetResourcePoliciesRequest(
        resourceArn,
        nextToken.map(value => value),
        maxResults.map(value => value)
      )
    def resourceArn: ResourceArnString
    def nextToken: Optional[String]
    def maxResults: Optional[ResourcePolicyMaxResults]
    def getResourceArn: ZIO[Any, Nothing, ResourceArnString] =
      ZIO.succeed(resourceArn)
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, AwsError, ResourcePolicyMaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ssm.model.GetResourcePoliciesRequest
  ) extends zio.aws.ssm.model.GetResourcePoliciesRequest.ReadOnly {
    override val resourceArn: ResourceArnString =
      zio.aws.ssm.model.primitives.ResourceArnString(impl.resourceArn())
    override val nextToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => value: String)
    override val maxResults: Optional[ResourcePolicyMaxResults] =
      zio.aws.core.internal
        .optionalFromNullable(impl.maxResults())
        .map(value =>
          zio.aws.ssm.model.primitives.ResourcePolicyMaxResults(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ssm.model.GetResourcePoliciesRequest
  ): zio.aws.ssm.model.GetResourcePoliciesRequest.ReadOnly = new Wrapper(impl)
}
