package zio.aws.ssm.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.ssm.model.primitives.{
  PlatformName,
  IamRole,
  InstanceRole,
  StatusName,
  InstanceId,
  InstanceType,
  KeyName,
  SourceId,
  ActivationId,
  DateTime,
  ComputerName,
  Version,
  InstanceName,
  InstanceState,
  PlatformVersion,
  IPAddress,
  Architecture
}
import scala.jdk.CollectionConverters.*
final case class InstanceProperty(
    name: Optional[InstanceName] = Optional.Absent,
    instanceId: Optional[InstanceId] = Optional.Absent,
    instanceType: Optional[InstanceType] = Optional.Absent,
    instanceRole: Optional[InstanceRole] = Optional.Absent,
    keyName: Optional[KeyName] = Optional.Absent,
    instanceState: Optional[InstanceState] = Optional.Absent,
    architecture: Optional[Architecture] = Optional.Absent,
    ipAddress: Optional[IPAddress] = Optional.Absent,
    launchTime: Optional[DateTime] = Optional.Absent,
    pingStatus: Optional[zio.aws.ssm.model.PingStatus] = Optional.Absent,
    lastPingDateTime: Optional[DateTime] = Optional.Absent,
    agentVersion: Optional[Version] = Optional.Absent,
    platformType: Optional[zio.aws.ssm.model.PlatformType] = Optional.Absent,
    platformName: Optional[PlatformName] = Optional.Absent,
    platformVersion: Optional[PlatformVersion] = Optional.Absent,
    activationId: Optional[ActivationId] = Optional.Absent,
    iamRole: Optional[IamRole] = Optional.Absent,
    registrationDate: Optional[DateTime] = Optional.Absent,
    resourceType: Optional[String] = Optional.Absent,
    computerName: Optional[ComputerName] = Optional.Absent,
    associationStatus: Optional[StatusName] = Optional.Absent,
    lastAssociationExecutionDate: Optional[DateTime] = Optional.Absent,
    lastSuccessfulAssociationExecutionDate: Optional[DateTime] =
      Optional.Absent,
    associationOverview: Optional[
      zio.aws.ssm.model.InstanceAggregatedAssociationOverview
    ] = Optional.Absent,
    sourceId: Optional[SourceId] = Optional.Absent,
    sourceType: Optional[zio.aws.ssm.model.SourceType] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ssm.model.InstanceProperty = {
    import InstanceProperty.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ssm.model.InstanceProperty
      .builder()
      .optionallyWith(
        name.map(value => InstanceName.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(
        instanceId.map(value => InstanceId.unwrap(value): java.lang.String)
      )(_.instanceId)
      .optionallyWith(
        instanceType.map(value => InstanceType.unwrap(value): java.lang.String)
      )(_.instanceType)
      .optionallyWith(
        instanceRole.map(value => InstanceRole.unwrap(value): java.lang.String)
      )(_.instanceRole)
      .optionallyWith(
        keyName.map(value => KeyName.unwrap(value): java.lang.String)
      )(_.keyName)
      .optionallyWith(
        instanceState.map(value =>
          InstanceState.unwrap(value): java.lang.String
        )
      )(_.instanceState)
      .optionallyWith(
        architecture.map(value => Architecture.unwrap(value): java.lang.String)
      )(_.architecture)
      .optionallyWith(
        ipAddress.map(value => IPAddress.unwrap(value): java.lang.String)
      )(_.ipAddress)
      .optionallyWith(launchTime.map(value => DateTime.unwrap(value): Instant))(
        _.launchTime
      )
      .optionallyWith(pingStatus.map(value => value.unwrap))(_.pingStatus)
      .optionallyWith(
        lastPingDateTime.map(value => DateTime.unwrap(value): Instant)
      )(_.lastPingDateTime)
      .optionallyWith(
        agentVersion.map(value => Version.unwrap(value): java.lang.String)
      )(_.agentVersion)
      .optionallyWith(platformType.map(value => value.unwrap))(_.platformType)
      .optionallyWith(
        platformName.map(value => PlatformName.unwrap(value): java.lang.String)
      )(_.platformName)
      .optionallyWith(
        platformVersion.map(value =>
          PlatformVersion.unwrap(value): java.lang.String
        )
      )(_.platformVersion)
      .optionallyWith(
        activationId.map(value => ActivationId.unwrap(value): java.lang.String)
      )(_.activationId)
      .optionallyWith(
        iamRole.map(value => IamRole.unwrap(value): java.lang.String)
      )(_.iamRole)
      .optionallyWith(
        registrationDate.map(value => DateTime.unwrap(value): Instant)
      )(_.registrationDate)
      .optionallyWith(resourceType.map(value => value: java.lang.String))(
        _.resourceType
      )
      .optionallyWith(
        computerName.map(value => ComputerName.unwrap(value): java.lang.String)
      )(_.computerName)
      .optionallyWith(
        associationStatus.map(value =>
          StatusName.unwrap(value): java.lang.String
        )
      )(_.associationStatus)
      .optionallyWith(
        lastAssociationExecutionDate.map(value =>
          DateTime.unwrap(value): Instant
        )
      )(_.lastAssociationExecutionDate)
      .optionallyWith(
        lastSuccessfulAssociationExecutionDate.map(value =>
          DateTime.unwrap(value): Instant
        )
      )(_.lastSuccessfulAssociationExecutionDate)
      .optionallyWith(associationOverview.map(value => value.buildAwsValue()))(
        _.associationOverview
      )
      .optionallyWith(
        sourceId.map(value => SourceId.unwrap(value): java.lang.String)
      )(_.sourceId)
      .optionallyWith(sourceType.map(value => value.unwrap))(_.sourceType)
      .build()
  }
  def asReadOnly: zio.aws.ssm.model.InstanceProperty.ReadOnly =
    zio.aws.ssm.model.InstanceProperty.wrap(buildAwsValue())
}
object InstanceProperty {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ssm.model.InstanceProperty
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ssm.model.InstanceProperty =
      zio.aws.ssm.model.InstanceProperty(
        name.map(value => value),
        instanceId.map(value => value),
        instanceType.map(value => value),
        instanceRole.map(value => value),
        keyName.map(value => value),
        instanceState.map(value => value),
        architecture.map(value => value),
        ipAddress.map(value => value),
        launchTime.map(value => value),
        pingStatus.map(value => value),
        lastPingDateTime.map(value => value),
        agentVersion.map(value => value),
        platformType.map(value => value),
        platformName.map(value => value),
        platformVersion.map(value => value),
        activationId.map(value => value),
        iamRole.map(value => value),
        registrationDate.map(value => value),
        resourceType.map(value => value),
        computerName.map(value => value),
        associationStatus.map(value => value),
        lastAssociationExecutionDate.map(value => value),
        lastSuccessfulAssociationExecutionDate.map(value => value),
        associationOverview.map(value => value.asEditable),
        sourceId.map(value => value),
        sourceType.map(value => value)
      )
    def name: Optional[InstanceName]
    def instanceId: Optional[InstanceId]
    def instanceType: Optional[InstanceType]
    def instanceRole: Optional[InstanceRole]
    def keyName: Optional[KeyName]
    def instanceState: Optional[InstanceState]
    def architecture: Optional[Architecture]
    def ipAddress: Optional[IPAddress]
    def launchTime: Optional[DateTime]
    def pingStatus: Optional[zio.aws.ssm.model.PingStatus]
    def lastPingDateTime: Optional[DateTime]
    def agentVersion: Optional[Version]
    def platformType: Optional[zio.aws.ssm.model.PlatformType]
    def platformName: Optional[PlatformName]
    def platformVersion: Optional[PlatformVersion]
    def activationId: Optional[ActivationId]
    def iamRole: Optional[IamRole]
    def registrationDate: Optional[DateTime]
    def resourceType: Optional[String]
    def computerName: Optional[ComputerName]
    def associationStatus: Optional[StatusName]
    def lastAssociationExecutionDate: Optional[DateTime]
    def lastSuccessfulAssociationExecutionDate: Optional[DateTime]
    def associationOverview: Optional[
      zio.aws.ssm.model.InstanceAggregatedAssociationOverview.ReadOnly
    ]
    def sourceId: Optional[SourceId]
    def sourceType: Optional[zio.aws.ssm.model.SourceType]
    def getName: ZIO[Any, AwsError, InstanceName] =
      AwsError.unwrapOptionField("name", name)
    def getInstanceId: ZIO[Any, AwsError, InstanceId] =
      AwsError.unwrapOptionField("instanceId", instanceId)
    def getInstanceType: ZIO[Any, AwsError, InstanceType] =
      AwsError.unwrapOptionField("instanceType", instanceType)
    def getInstanceRole: ZIO[Any, AwsError, InstanceRole] =
      AwsError.unwrapOptionField("instanceRole", instanceRole)
    def getKeyName: ZIO[Any, AwsError, KeyName] =
      AwsError.unwrapOptionField("keyName", keyName)
    def getInstanceState: ZIO[Any, AwsError, InstanceState] =
      AwsError.unwrapOptionField("instanceState", instanceState)
    def getArchitecture: ZIO[Any, AwsError, Architecture] =
      AwsError.unwrapOptionField("architecture", architecture)
    def getIpAddress: ZIO[Any, AwsError, IPAddress] =
      AwsError.unwrapOptionField("ipAddress", ipAddress)
    def getLaunchTime: ZIO[Any, AwsError, DateTime] =
      AwsError.unwrapOptionField("launchTime", launchTime)
    def getPingStatus: ZIO[Any, AwsError, zio.aws.ssm.model.PingStatus] =
      AwsError.unwrapOptionField("pingStatus", pingStatus)
    def getLastPingDateTime: ZIO[Any, AwsError, DateTime] =
      AwsError.unwrapOptionField("lastPingDateTime", lastPingDateTime)
    def getAgentVersion: ZIO[Any, AwsError, Version] =
      AwsError.unwrapOptionField("agentVersion", agentVersion)
    def getPlatformType: ZIO[Any, AwsError, zio.aws.ssm.model.PlatformType] =
      AwsError.unwrapOptionField("platformType", platformType)
    def getPlatformName: ZIO[Any, AwsError, PlatformName] =
      AwsError.unwrapOptionField("platformName", platformName)
    def getPlatformVersion: ZIO[Any, AwsError, PlatformVersion] =
      AwsError.unwrapOptionField("platformVersion", platformVersion)
    def getActivationId: ZIO[Any, AwsError, ActivationId] =
      AwsError.unwrapOptionField("activationId", activationId)
    def getIamRole: ZIO[Any, AwsError, IamRole] =
      AwsError.unwrapOptionField("iamRole", iamRole)
    def getRegistrationDate: ZIO[Any, AwsError, DateTime] =
      AwsError.unwrapOptionField("registrationDate", registrationDate)
    def getResourceType: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("resourceType", resourceType)
    def getComputerName: ZIO[Any, AwsError, ComputerName] =
      AwsError.unwrapOptionField("computerName", computerName)
    def getAssociationStatus: ZIO[Any, AwsError, StatusName] =
      AwsError.unwrapOptionField("associationStatus", associationStatus)
    def getLastAssociationExecutionDate: ZIO[Any, AwsError, DateTime] =
      AwsError.unwrapOptionField(
        "lastAssociationExecutionDate",
        lastAssociationExecutionDate
      )
    def getLastSuccessfulAssociationExecutionDate
        : ZIO[Any, AwsError, DateTime] = AwsError.unwrapOptionField(
      "lastSuccessfulAssociationExecutionDate",
      lastSuccessfulAssociationExecutionDate
    )
    def getAssociationOverview: ZIO[
      Any,
      AwsError,
      zio.aws.ssm.model.InstanceAggregatedAssociationOverview.ReadOnly
    ] = AwsError.unwrapOptionField("associationOverview", associationOverview)
    def getSourceId: ZIO[Any, AwsError, SourceId] =
      AwsError.unwrapOptionField("sourceId", sourceId)
    def getSourceType: ZIO[Any, AwsError, zio.aws.ssm.model.SourceType] =
      AwsError.unwrapOptionField("sourceType", sourceType)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ssm.model.InstanceProperty
  ) extends zio.aws.ssm.model.InstanceProperty.ReadOnly {
    override val name: Optional[InstanceName] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => zio.aws.ssm.model.primitives.InstanceName(value))
    override val instanceId: Optional[InstanceId] = zio.aws.core.internal
      .optionalFromNullable(impl.instanceId())
      .map(value => zio.aws.ssm.model.primitives.InstanceId(value))
    override val instanceType: Optional[InstanceType] = zio.aws.core.internal
      .optionalFromNullable(impl.instanceType())
      .map(value => zio.aws.ssm.model.primitives.InstanceType(value))
    override val instanceRole: Optional[InstanceRole] = zio.aws.core.internal
      .optionalFromNullable(impl.instanceRole())
      .map(value => zio.aws.ssm.model.primitives.InstanceRole(value))
    override val keyName: Optional[KeyName] = zio.aws.core.internal
      .optionalFromNullable(impl.keyName())
      .map(value => zio.aws.ssm.model.primitives.KeyName(value))
    override val instanceState: Optional[InstanceState] = zio.aws.core.internal
      .optionalFromNullable(impl.instanceState())
      .map(value => zio.aws.ssm.model.primitives.InstanceState(value))
    override val architecture: Optional[Architecture] = zio.aws.core.internal
      .optionalFromNullable(impl.architecture())
      .map(value => zio.aws.ssm.model.primitives.Architecture(value))
    override val ipAddress: Optional[IPAddress] = zio.aws.core.internal
      .optionalFromNullable(impl.ipAddress())
      .map(value => zio.aws.ssm.model.primitives.IPAddress(value))
    override val launchTime: Optional[DateTime] = zio.aws.core.internal
      .optionalFromNullable(impl.launchTime())
      .map(value => zio.aws.ssm.model.primitives.DateTime(value))
    override val pingStatus: Optional[zio.aws.ssm.model.PingStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.pingStatus())
        .map(value => zio.aws.ssm.model.PingStatus.wrap(value))
    override val lastPingDateTime: Optional[DateTime] = zio.aws.core.internal
      .optionalFromNullable(impl.lastPingDateTime())
      .map(value => zio.aws.ssm.model.primitives.DateTime(value))
    override val agentVersion: Optional[Version] = zio.aws.core.internal
      .optionalFromNullable(impl.agentVersion())
      .map(value => zio.aws.ssm.model.primitives.Version(value))
    override val platformType: Optional[zio.aws.ssm.model.PlatformType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.platformType())
        .map(value => zio.aws.ssm.model.PlatformType.wrap(value))
    override val platformName: Optional[PlatformName] = zio.aws.core.internal
      .optionalFromNullable(impl.platformName())
      .map(value => zio.aws.ssm.model.primitives.PlatformName(value))
    override val platformVersion: Optional[PlatformVersion] =
      zio.aws.core.internal
        .optionalFromNullable(impl.platformVersion())
        .map(value => zio.aws.ssm.model.primitives.PlatformVersion(value))
    override val activationId: Optional[ActivationId] = zio.aws.core.internal
      .optionalFromNullable(impl.activationId())
      .map(value => zio.aws.ssm.model.primitives.ActivationId(value))
    override val iamRole: Optional[IamRole] = zio.aws.core.internal
      .optionalFromNullable(impl.iamRole())
      .map(value => zio.aws.ssm.model.primitives.IamRole(value))
    override val registrationDate: Optional[DateTime] = zio.aws.core.internal
      .optionalFromNullable(impl.registrationDate())
      .map(value => zio.aws.ssm.model.primitives.DateTime(value))
    override val resourceType: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.resourceType())
      .map(value => value: String)
    override val computerName: Optional[ComputerName] = zio.aws.core.internal
      .optionalFromNullable(impl.computerName())
      .map(value => zio.aws.ssm.model.primitives.ComputerName(value))
    override val associationStatus: Optional[StatusName] = zio.aws.core.internal
      .optionalFromNullable(impl.associationStatus())
      .map(value => zio.aws.ssm.model.primitives.StatusName(value))
    override val lastAssociationExecutionDate: Optional[DateTime] =
      zio.aws.core.internal
        .optionalFromNullable(impl.lastAssociationExecutionDate())
        .map(value => zio.aws.ssm.model.primitives.DateTime(value))
    override val lastSuccessfulAssociationExecutionDate: Optional[DateTime] =
      zio.aws.core.internal
        .optionalFromNullable(impl.lastSuccessfulAssociationExecutionDate())
        .map(value => zio.aws.ssm.model.primitives.DateTime(value))
    override val associationOverview: Optional[
      zio.aws.ssm.model.InstanceAggregatedAssociationOverview.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.associationOverview())
      .map(value =>
        zio.aws.ssm.model.InstanceAggregatedAssociationOverview.wrap(value)
      )
    override val sourceId: Optional[SourceId] = zio.aws.core.internal
      .optionalFromNullable(impl.sourceId())
      .map(value => zio.aws.ssm.model.primitives.SourceId(value))
    override val sourceType: Optional[zio.aws.ssm.model.SourceType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.sourceType())
        .map(value => zio.aws.ssm.model.SourceType.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ssm.model.InstanceProperty
  ): zio.aws.ssm.model.InstanceProperty.ReadOnly = new Wrapper(impl)
}
