package zio.aws.ssm.model
import zio.aws.ssm.model.primitives.InstancePropertyFilterValue
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class InstancePropertyFilter(
    key: zio.aws.ssm.model.InstancePropertyFilterKey,
    valueSet: Iterable[InstancePropertyFilterValue]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ssm.model.InstancePropertyFilter = {
    import InstancePropertyFilter.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ssm.model.InstancePropertyFilter
      .builder()
      .key(key.unwrap)
      .valueSet(valueSet.map { item =>
        InstancePropertyFilterValue.unwrap(item): java.lang.String
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.ssm.model.InstancePropertyFilter.ReadOnly =
    zio.aws.ssm.model.InstancePropertyFilter.wrap(buildAwsValue())
}
object InstancePropertyFilter {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ssm.model.InstancePropertyFilter
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ssm.model.InstancePropertyFilter =
      zio.aws.ssm.model.InstancePropertyFilter(key, valueSet)
    def key: zio.aws.ssm.model.InstancePropertyFilterKey
    def valueSet: List[InstancePropertyFilterValue]
    def getKey: ZIO[Any, Nothing, zio.aws.ssm.model.InstancePropertyFilterKey] =
      ZIO.succeed(key)
    def getValueSet: ZIO[Any, Nothing, List[InstancePropertyFilterValue]] =
      ZIO.succeed(valueSet)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ssm.model.InstancePropertyFilter
  ) extends zio.aws.ssm.model.InstancePropertyFilter.ReadOnly {
    override val key: zio.aws.ssm.model.InstancePropertyFilterKey =
      zio.aws.ssm.model.InstancePropertyFilterKey.wrap(impl.key())
    override val valueSet: List[InstancePropertyFilterValue] = impl
      .valueSet()
      .asScala
      .map { item =>
        zio.aws.ssm.model.primitives.InstancePropertyFilterValue(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.ssm.model.InstancePropertyFilter
  ): zio.aws.ssm.model.InstancePropertyFilter.ReadOnly = new Wrapper(impl)
}
