package zio.aws.ssm.model
import scala.jdk.CollectionConverters.*
sealed trait InstancePropertyFilterKey {
  def unwrap
      : software.amazon.awssdk.services.ssm.model.InstancePropertyFilterKey
}
object InstancePropertyFilterKey {
  def wrap(
      value: software.amazon.awssdk.services.ssm.model.InstancePropertyFilterKey
  ): zio.aws.ssm.model.InstancePropertyFilterKey = value match {
    case software.amazon.awssdk.services.ssm.model.InstancePropertyFilterKey.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.ssm.model.InstancePropertyFilterKey.INSTANCE_IDS =>
      val r = InstanceIds
      r
    case software.amazon.awssdk.services.ssm.model.InstancePropertyFilterKey.AGENT_VERSION =>
      val r = AgentVersion
      r
    case software.amazon.awssdk.services.ssm.model.InstancePropertyFilterKey.PING_STATUS =>
      val r = PingStatus
      r
    case software.amazon.awssdk.services.ssm.model.InstancePropertyFilterKey.PLATFORM_TYPES =>
      val r = PlatformTypes
      r
    case software.amazon.awssdk.services.ssm.model.InstancePropertyFilterKey.DOCUMENT_NAME =>
      val r = DocumentName
      r
    case software.amazon.awssdk.services.ssm.model.InstancePropertyFilterKey.ACTIVATION_IDS =>
      val r = ActivationIds
      r
    case software.amazon.awssdk.services.ssm.model.InstancePropertyFilterKey.IAM_ROLE =>
      val r = IamRole
      r
    case software.amazon.awssdk.services.ssm.model.InstancePropertyFilterKey.RESOURCE_TYPE =>
      val r = ResourceType
      r
    case software.amazon.awssdk.services.ssm.model.InstancePropertyFilterKey.ASSOCIATION_STATUS =>
      val r = AssociationStatus
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.ssm.model.InstancePropertyFilterKey {
    override def unwrap
        : software.amazon.awssdk.services.ssm.model.InstancePropertyFilterKey =
      software.amazon.awssdk.services.ssm.model.InstancePropertyFilterKey.UNKNOWN_TO_SDK_VERSION
  }
  case object InstanceIds extends zio.aws.ssm.model.InstancePropertyFilterKey {
    override def unwrap
        : software.amazon.awssdk.services.ssm.model.InstancePropertyFilterKey =
      software.amazon.awssdk.services.ssm.model.InstancePropertyFilterKey.INSTANCE_IDS
  }
  case object AgentVersion extends zio.aws.ssm.model.InstancePropertyFilterKey {
    override def unwrap
        : software.amazon.awssdk.services.ssm.model.InstancePropertyFilterKey =
      software.amazon.awssdk.services.ssm.model.InstancePropertyFilterKey.AGENT_VERSION
  }
  case object PingStatus extends zio.aws.ssm.model.InstancePropertyFilterKey {
    override def unwrap
        : software.amazon.awssdk.services.ssm.model.InstancePropertyFilterKey =
      software.amazon.awssdk.services.ssm.model.InstancePropertyFilterKey.PING_STATUS
  }
  case object PlatformTypes
      extends zio.aws.ssm.model.InstancePropertyFilterKey {
    override def unwrap
        : software.amazon.awssdk.services.ssm.model.InstancePropertyFilterKey =
      software.amazon.awssdk.services.ssm.model.InstancePropertyFilterKey.PLATFORM_TYPES
  }
  case object DocumentName extends zio.aws.ssm.model.InstancePropertyFilterKey {
    override def unwrap
        : software.amazon.awssdk.services.ssm.model.InstancePropertyFilterKey =
      software.amazon.awssdk.services.ssm.model.InstancePropertyFilterKey.DOCUMENT_NAME
  }
  case object ActivationIds
      extends zio.aws.ssm.model.InstancePropertyFilterKey {
    override def unwrap
        : software.amazon.awssdk.services.ssm.model.InstancePropertyFilterKey =
      software.amazon.awssdk.services.ssm.model.InstancePropertyFilterKey.ACTIVATION_IDS
  }
  case object IamRole extends zio.aws.ssm.model.InstancePropertyFilterKey {
    override def unwrap
        : software.amazon.awssdk.services.ssm.model.InstancePropertyFilterKey =
      software.amazon.awssdk.services.ssm.model.InstancePropertyFilterKey.IAM_ROLE
  }
  case object ResourceType extends zio.aws.ssm.model.InstancePropertyFilterKey {
    override def unwrap
        : software.amazon.awssdk.services.ssm.model.InstancePropertyFilterKey =
      software.amazon.awssdk.services.ssm.model.InstancePropertyFilterKey.RESOURCE_TYPE
  }
  case object AssociationStatus
      extends zio.aws.ssm.model.InstancePropertyFilterKey {
    override def unwrap
        : software.amazon.awssdk.services.ssm.model.InstancePropertyFilterKey =
      software.amazon.awssdk.services.ssm.model.InstancePropertyFilterKey.ASSOCIATION_STATUS
  }
}
