package zio.aws.ssm.model
import scala.jdk.CollectionConverters.*
sealed trait InstancePropertyFilterOperator {
  def unwrap
      : software.amazon.awssdk.services.ssm.model.InstancePropertyFilterOperator
}
object InstancePropertyFilterOperator {
  def wrap(
      value: software.amazon.awssdk.services.ssm.model.InstancePropertyFilterOperator
  ): zio.aws.ssm.model.InstancePropertyFilterOperator = value match {
    case software.amazon.awssdk.services.ssm.model.InstancePropertyFilterOperator.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.ssm.model.InstancePropertyFilterOperator.EQUAL =>
      val r = Equal
      r
    case software.amazon.awssdk.services.ssm.model.InstancePropertyFilterOperator.NOT_EQUAL =>
      val r = NotEqual
      r
    case software.amazon.awssdk.services.ssm.model.InstancePropertyFilterOperator.BEGIN_WITH =>
      val r = BeginWith
      r
    case software.amazon.awssdk.services.ssm.model.InstancePropertyFilterOperator.LESS_THAN =>
      val r = LessThan
      r
    case software.amazon.awssdk.services.ssm.model.InstancePropertyFilterOperator.GREATER_THAN =>
      val r = GreaterThan
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.ssm.model.InstancePropertyFilterOperator {
    override def unwrap
        : software.amazon.awssdk.services.ssm.model.InstancePropertyFilterOperator =
      software.amazon.awssdk.services.ssm.model.InstancePropertyFilterOperator.UNKNOWN_TO_SDK_VERSION
  }
  case object Equal extends zio.aws.ssm.model.InstancePropertyFilterOperator {
    override def unwrap
        : software.amazon.awssdk.services.ssm.model.InstancePropertyFilterOperator =
      software.amazon.awssdk.services.ssm.model.InstancePropertyFilterOperator.EQUAL
  }
  case object NotEqual
      extends zio.aws.ssm.model.InstancePropertyFilterOperator {
    override def unwrap
        : software.amazon.awssdk.services.ssm.model.InstancePropertyFilterOperator =
      software.amazon.awssdk.services.ssm.model.InstancePropertyFilterOperator.NOT_EQUAL
  }
  case object BeginWith
      extends zio.aws.ssm.model.InstancePropertyFilterOperator {
    override def unwrap
        : software.amazon.awssdk.services.ssm.model.InstancePropertyFilterOperator =
      software.amazon.awssdk.services.ssm.model.InstancePropertyFilterOperator.BEGIN_WITH
  }
  case object LessThan
      extends zio.aws.ssm.model.InstancePropertyFilterOperator {
    override def unwrap
        : software.amazon.awssdk.services.ssm.model.InstancePropertyFilterOperator =
      software.amazon.awssdk.services.ssm.model.InstancePropertyFilterOperator.LESS_THAN
  }
  case object GreaterThan
      extends zio.aws.ssm.model.InstancePropertyFilterOperator {
    override def unwrap
        : software.amazon.awssdk.services.ssm.model.InstancePropertyFilterOperator =
      software.amazon.awssdk.services.ssm.model.InstancePropertyFilterOperator.GREATER_THAN
  }
}
