package zio.aws.ssm.model
import zio.aws.ssm.model.primitives.{
  InstancePropertyFilterValue,
  InstancePropertyStringFilterKey
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class InstancePropertyStringFilter(
    key: InstancePropertyStringFilterKey,
    values: Iterable[InstancePropertyFilterValue],
    operator: Optional[zio.aws.ssm.model.InstancePropertyFilterOperator] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ssm.model.InstancePropertyStringFilter = {
    import InstancePropertyStringFilter.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ssm.model.InstancePropertyStringFilter
      .builder()
      .key(InstancePropertyStringFilterKey.unwrap(key): java.lang.String)
      .values(values.map { item =>
        InstancePropertyFilterValue.unwrap(item): java.lang.String
      }.asJavaCollection)
      .optionallyWith(operator.map(value => value.unwrap))(_.operator)
      .build()
  }
  def asReadOnly: zio.aws.ssm.model.InstancePropertyStringFilter.ReadOnly =
    zio.aws.ssm.model.InstancePropertyStringFilter.wrap(buildAwsValue())
}
object InstancePropertyStringFilter {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ssm.model.InstancePropertyStringFilter
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ssm.model.InstancePropertyStringFilter =
      zio.aws.ssm.model
        .InstancePropertyStringFilter(key, values, operator.map(value => value))
    def key: InstancePropertyStringFilterKey
    def values: List[InstancePropertyFilterValue]
    def operator: Optional[zio.aws.ssm.model.InstancePropertyFilterOperator]
    def getKey: ZIO[Any, Nothing, InstancePropertyStringFilterKey] =
      ZIO.succeed(key)
    def getValues: ZIO[Any, Nothing, List[InstancePropertyFilterValue]] =
      ZIO.succeed(values)
    def getOperator
        : ZIO[Any, AwsError, zio.aws.ssm.model.InstancePropertyFilterOperator] =
      AwsError.unwrapOptionField("operator", operator)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ssm.model.InstancePropertyStringFilter
  ) extends zio.aws.ssm.model.InstancePropertyStringFilter.ReadOnly {
    override val key: InstancePropertyStringFilterKey =
      zio.aws.ssm.model.primitives.InstancePropertyStringFilterKey(impl.key())
    override val values: List[InstancePropertyFilterValue] = impl
      .values()
      .asScala
      .map { item =>
        zio.aws.ssm.model.primitives.InstancePropertyFilterValue(item)
      }
      .toList
    override val operator
        : Optional[zio.aws.ssm.model.InstancePropertyFilterOperator] =
      zio.aws.core.internal
        .optionalFromNullable(impl.operator())
        .map(value =>
          zio.aws.ssm.model.InstancePropertyFilterOperator.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ssm.model.InstancePropertyStringFilter
  ): zio.aws.ssm.model.InstancePropertyStringFilter.ReadOnly = new Wrapper(impl)
}
