package zio.aws.ssm.model
import zio.aws.ssm.model.primitives.InventoryAggregatorExpression
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class InventoryAggregator(
    expression: Optional[InventoryAggregatorExpression] = Optional.Absent,
    aggregators: Optional[Iterable[zio.aws.ssm.model.InventoryAggregator]] =
      Optional.Absent,
    groups: Optional[Iterable[zio.aws.ssm.model.InventoryGroup]] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ssm.model.InventoryAggregator = {
    import InventoryAggregator.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ssm.model.InventoryAggregator
      .builder()
      .optionallyWith(
        expression.map(value =>
          InventoryAggregatorExpression.unwrap(value): java.lang.String
        )
      )(_.expression)
      .optionallyWith(
        aggregators.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.aggregators)
      .optionallyWith(
        groups.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.groups)
      .build()
  }
  def asReadOnly: zio.aws.ssm.model.InventoryAggregator.ReadOnly =
    zio.aws.ssm.model.InventoryAggregator.wrap(buildAwsValue())
}
object InventoryAggregator {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ssm.model.InventoryAggregator
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ssm.model.InventoryAggregator =
      zio.aws.ssm.model.InventoryAggregator(
        expression.map(value => value),
        aggregators.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        groups.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def expression: Optional[InventoryAggregatorExpression]
    def aggregators
        : Optional[List[zio.aws.ssm.model.InventoryAggregator.ReadOnly]]
    def groups: Optional[List[zio.aws.ssm.model.InventoryGroup.ReadOnly]]
    def getExpression: ZIO[Any, AwsError, InventoryAggregatorExpression] =
      AwsError.unwrapOptionField("expression", expression)
    def getAggregators: ZIO[Any, AwsError, List[
      zio.aws.ssm.model.InventoryAggregator.ReadOnly
    ]] = AwsError.unwrapOptionField("aggregators", aggregators)
    def getGroups
        : ZIO[Any, AwsError, List[zio.aws.ssm.model.InventoryGroup.ReadOnly]] =
      AwsError.unwrapOptionField("groups", groups)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ssm.model.InventoryAggregator
  ) extends zio.aws.ssm.model.InventoryAggregator.ReadOnly {
    override val expression: Optional[InventoryAggregatorExpression] =
      zio.aws.core.internal
        .optionalFromNullable(impl.expression())
        .map(value =>
          zio.aws.ssm.model.primitives.InventoryAggregatorExpression(value)
        )
    override val aggregators
        : Optional[List[zio.aws.ssm.model.InventoryAggregator.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.aggregators())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ssm.model.InventoryAggregator.wrap(item)
          }.toList
        )
    override val groups
        : Optional[List[zio.aws.ssm.model.InventoryGroup.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.groups())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ssm.model.InventoryGroup.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ssm.model.InventoryAggregator
  ): zio.aws.ssm.model.InventoryAggregator.ReadOnly = new Wrapper(impl)
}
