package zio.aws.ssm.model
import zio.aws.ssm.model.primitives.{
  NextToken,
  AttributeName,
  InventoryItemSchemaVersion,
  InventoryItemCaptureTime,
  InstanceId,
  InventoryItemTypeName,
  AttributeValue
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ListInventoryEntriesResponse(
    typeName: Optional[InventoryItemTypeName] = Optional.Absent,
    instanceId: Optional[InstanceId] = Optional.Absent,
    schemaVersion: Optional[InventoryItemSchemaVersion] = Optional.Absent,
    captureTime: Optional[InventoryItemCaptureTime] = Optional.Absent,
    entries: Optional[Iterable[Map[AttributeName, AttributeValue]]] =
      Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ssm.model.ListInventoryEntriesResponse = {
    import ListInventoryEntriesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ssm.model.ListInventoryEntriesResponse
      .builder()
      .optionallyWith(
        typeName.map(value =>
          InventoryItemTypeName.unwrap(value): java.lang.String
        )
      )(_.typeName)
      .optionallyWith(
        instanceId.map(value => InstanceId.unwrap(value): java.lang.String)
      )(_.instanceId)
      .optionallyWith(
        schemaVersion.map(value =>
          InventoryItemSchemaVersion.unwrap(value): java.lang.String
        )
      )(_.schemaVersion)
      .optionallyWith(
        captureTime.map(value =>
          InventoryItemCaptureTime.unwrap(value): java.lang.String
        )
      )(_.captureTime)
      .optionallyWith(
        entries.map(value =>
          value.map { item =>
            item
              .map({ case (key, value) =>
                (AttributeName.unwrap(key): java.lang.String) -> (AttributeValue
                  .unwrap(value): java.lang.String)
              })
              .asJava
          }.asJavaCollection
        )
      )(_.entries)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.ssm.model.ListInventoryEntriesResponse.ReadOnly =
    zio.aws.ssm.model.ListInventoryEntriesResponse.wrap(buildAwsValue())
}
object ListInventoryEntriesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ssm.model.ListInventoryEntriesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ssm.model.ListInventoryEntriesResponse =
      zio.aws.ssm.model.ListInventoryEntriesResponse(
        typeName.map(value => value),
        instanceId.map(value => value),
        schemaVersion.map(value => value),
        captureTime.map(value => value),
        entries.map(value => value),
        nextToken.map(value => value)
      )
    def typeName: Optional[InventoryItemTypeName]
    def instanceId: Optional[InstanceId]
    def schemaVersion: Optional[InventoryItemSchemaVersion]
    def captureTime: Optional[InventoryItemCaptureTime]
    def entries: Optional[List[Map[AttributeName, AttributeValue]]]
    def nextToken: Optional[NextToken]
    def getTypeName: ZIO[Any, AwsError, InventoryItemTypeName] =
      AwsError.unwrapOptionField("typeName", typeName)
    def getInstanceId: ZIO[Any, AwsError, InstanceId] =
      AwsError.unwrapOptionField("instanceId", instanceId)
    def getSchemaVersion: ZIO[Any, AwsError, InventoryItemSchemaVersion] =
      AwsError.unwrapOptionField("schemaVersion", schemaVersion)
    def getCaptureTime: ZIO[Any, AwsError, InventoryItemCaptureTime] =
      AwsError.unwrapOptionField("captureTime", captureTime)
    def getEntries
        : ZIO[Any, AwsError, List[Map[AttributeName, AttributeValue]]] =
      AwsError.unwrapOptionField("entries", entries)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ssm.model.ListInventoryEntriesResponse
  ) extends zio.aws.ssm.model.ListInventoryEntriesResponse.ReadOnly {
    override val typeName: Optional[InventoryItemTypeName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.typeName())
        .map(value => zio.aws.ssm.model.primitives.InventoryItemTypeName(value))
    override val instanceId: Optional[InstanceId] = zio.aws.core.internal
      .optionalFromNullable(impl.instanceId())
      .map(value => zio.aws.ssm.model.primitives.InstanceId(value))
    override val schemaVersion: Optional[InventoryItemSchemaVersion] =
      zio.aws.core.internal
        .optionalFromNullable(impl.schemaVersion())
        .map(value =>
          zio.aws.ssm.model.primitives.InventoryItemSchemaVersion(value)
        )
    override val captureTime: Optional[InventoryItemCaptureTime] =
      zio.aws.core.internal
        .optionalFromNullable(impl.captureTime())
        .map(value =>
          zio.aws.ssm.model.primitives.InventoryItemCaptureTime(value)
        )
    override val entries: Optional[List[Map[AttributeName, AttributeValue]]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.entries())
        .map(value =>
          value.asScala.map { item =>
            item.asScala
              .map({ case (key, value) =>
                zio.aws.ssm.model.primitives.AttributeName(
                  key
                ) -> zio.aws.ssm.model.primitives.AttributeValue(value)
              })
              .toMap
          }.toList
        )
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.ssm.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ssm.model.ListInventoryEntriesResponse
  ): zio.aws.ssm.model.ListInventoryEntriesResponse.ReadOnly = new Wrapper(impl)
}
