package zio.aws.ssm.model
import scala.jdk.CollectionConverters.*
sealed trait MaintenanceWindowResourceType {
  def unwrap
      : software.amazon.awssdk.services.ssm.model.MaintenanceWindowResourceType
}
object MaintenanceWindowResourceType {
  def wrap(
      value: software.amazon.awssdk.services.ssm.model.MaintenanceWindowResourceType
  ): zio.aws.ssm.model.MaintenanceWindowResourceType = value match {
    case software.amazon.awssdk.services.ssm.model.MaintenanceWindowResourceType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.ssm.model.MaintenanceWindowResourceType.INSTANCE =>
      val r = INSTANCE
      r
    case software.amazon.awssdk.services.ssm.model.MaintenanceWindowResourceType.RESOURCE_GROUP =>
      val r = RESOURCE_GROUP
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.ssm.model.MaintenanceWindowResourceType {
    override def unwrap
        : software.amazon.awssdk.services.ssm.model.MaintenanceWindowResourceType =
      software.amazon.awssdk.services.ssm.model.MaintenanceWindowResourceType.UNKNOWN_TO_SDK_VERSION
  }
  case object INSTANCE extends zio.aws.ssm.model.MaintenanceWindowResourceType {
    override def unwrap
        : software.amazon.awssdk.services.ssm.model.MaintenanceWindowResourceType =
      software.amazon.awssdk.services.ssm.model.MaintenanceWindowResourceType.INSTANCE
  }
  case object RESOURCE_GROUP
      extends zio.aws.ssm.model.MaintenanceWindowResourceType {
    override def unwrap
        : software.amazon.awssdk.services.ssm.model.MaintenanceWindowResourceType =
      software.amazon.awssdk.services.ssm.model.MaintenanceWindowResourceType.RESOURCE_GROUP
  }
}
