package zio.aws.ssm.model
import zio.aws.ssm.model.primitives.NotificationArn
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class NotificationConfig(
    notificationArn: Optional[NotificationArn] = Optional.Absent,
    notificationEvents: Optional[
      Iterable[zio.aws.ssm.model.NotificationEvent]
    ] = Optional.Absent,
    notificationType: Optional[zio.aws.ssm.model.NotificationType] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ssm.model.NotificationConfig = {
    import NotificationConfig.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ssm.model.NotificationConfig
      .builder()
      .optionallyWith(
        notificationArn.map(value =>
          NotificationArn.unwrap(value): java.lang.String
        )
      )(_.notificationArn)
      .optionallyWith(
        notificationEvents.map(value =>
          value.map { item =>
            item.unwrap.toString
          }.asJavaCollection
        )
      )(_.notificationEventsWithStrings)
      .optionallyWith(notificationType.map(value => value.unwrap))(
        _.notificationType
      )
      .build()
  }
  def asReadOnly: zio.aws.ssm.model.NotificationConfig.ReadOnly =
    zio.aws.ssm.model.NotificationConfig.wrap(buildAwsValue())
}
object NotificationConfig {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ssm.model.NotificationConfig
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ssm.model.NotificationConfig =
      zio.aws.ssm.model.NotificationConfig(
        notificationArn.map(value => value),
        notificationEvents.map(value => value),
        notificationType.map(value => value)
      )
    def notificationArn: Optional[NotificationArn]
    def notificationEvents: Optional[List[zio.aws.ssm.model.NotificationEvent]]
    def notificationType: Optional[zio.aws.ssm.model.NotificationType]
    def getNotificationArn: ZIO[Any, AwsError, NotificationArn] =
      AwsError.unwrapOptionField("notificationArn", notificationArn)
    def getNotificationEvents
        : ZIO[Any, AwsError, List[zio.aws.ssm.model.NotificationEvent]] =
      AwsError.unwrapOptionField("notificationEvents", notificationEvents)
    def getNotificationType
        : ZIO[Any, AwsError, zio.aws.ssm.model.NotificationType] =
      AwsError.unwrapOptionField("notificationType", notificationType)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ssm.model.NotificationConfig
  ) extends zio.aws.ssm.model.NotificationConfig.ReadOnly {
    override val notificationArn: Optional[NotificationArn] =
      zio.aws.core.internal
        .optionalFromNullable(impl.notificationArn())
        .map(value => zio.aws.ssm.model.primitives.NotificationArn(value))
    override val notificationEvents
        : Optional[List[zio.aws.ssm.model.NotificationEvent]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.notificationEvents())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ssm.model.NotificationEvent.wrap(item)
          }.toList
        )
    override val notificationType
        : Optional[zio.aws.ssm.model.NotificationType] = zio.aws.core.internal
      .optionalFromNullable(impl.notificationType())
      .map(value => zio.aws.ssm.model.NotificationType.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ssm.model.NotificationConfig
  ): zio.aws.ssm.model.NotificationConfig.ReadOnly = new Wrapper(impl)
}
