package zio.aws.ssm.model
import scala.jdk.CollectionConverters.*
sealed trait NotificationEvent {
  def unwrap: software.amazon.awssdk.services.ssm.model.NotificationEvent
}
object NotificationEvent {
  def wrap(
      value: software.amazon.awssdk.services.ssm.model.NotificationEvent
  ): zio.aws.ssm.model.NotificationEvent = value match {
    case software.amazon.awssdk.services.ssm.model.NotificationEvent.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.ssm.model.NotificationEvent.ALL =>
      val r = All
      r
    case software.amazon.awssdk.services.ssm.model.NotificationEvent.IN_PROGRESS =>
      val r = InProgress
      r
    case software.amazon.awssdk.services.ssm.model.NotificationEvent.SUCCESS =>
      val r = Success
      r
    case software.amazon.awssdk.services.ssm.model.NotificationEvent.TIMED_OUT =>
      val r = TimedOut
      r
    case software.amazon.awssdk.services.ssm.model.NotificationEvent.CANCELLED =>
      val r = Cancelled
      r
    case software.amazon.awssdk.services.ssm.model.NotificationEvent.FAILED =>
      val r = Failed
      r
  }
  case object unknownToSdkVersion extends zio.aws.ssm.model.NotificationEvent {
    override def unwrap
        : software.amazon.awssdk.services.ssm.model.NotificationEvent =
      software.amazon.awssdk.services.ssm.model.NotificationEvent.UNKNOWN_TO_SDK_VERSION
  }
  case object All extends zio.aws.ssm.model.NotificationEvent {
    override def unwrap
        : software.amazon.awssdk.services.ssm.model.NotificationEvent =
      software.amazon.awssdk.services.ssm.model.NotificationEvent.ALL
  }
  case object InProgress extends zio.aws.ssm.model.NotificationEvent {
    override def unwrap
        : software.amazon.awssdk.services.ssm.model.NotificationEvent =
      software.amazon.awssdk.services.ssm.model.NotificationEvent.IN_PROGRESS
  }
  case object Success extends zio.aws.ssm.model.NotificationEvent {
    override def unwrap
        : software.amazon.awssdk.services.ssm.model.NotificationEvent =
      software.amazon.awssdk.services.ssm.model.NotificationEvent.SUCCESS
  }
  case object TimedOut extends zio.aws.ssm.model.NotificationEvent {
    override def unwrap
        : software.amazon.awssdk.services.ssm.model.NotificationEvent =
      software.amazon.awssdk.services.ssm.model.NotificationEvent.TIMED_OUT
  }
  case object Cancelled extends zio.aws.ssm.model.NotificationEvent {
    override def unwrap
        : software.amazon.awssdk.services.ssm.model.NotificationEvent =
      software.amazon.awssdk.services.ssm.model.NotificationEvent.CANCELLED
  }
  case object Failed extends zio.aws.ssm.model.NotificationEvent {
    override def unwrap
        : software.amazon.awssdk.services.ssm.model.NotificationEvent =
      software.amazon.awssdk.services.ssm.model.NotificationEvent.FAILED
  }
}
