package zio.aws.ssm.model
import scala.jdk.CollectionConverters.*
sealed trait OpsFilterOperatorType {
  def unwrap: software.amazon.awssdk.services.ssm.model.OpsFilterOperatorType
}
object OpsFilterOperatorType {
  def wrap(
      value: software.amazon.awssdk.services.ssm.model.OpsFilterOperatorType
  ): zio.aws.ssm.model.OpsFilterOperatorType = value match {
    case software.amazon.awssdk.services.ssm.model.OpsFilterOperatorType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.ssm.model.OpsFilterOperatorType.EQUAL =>
      val r = Equal
      r
    case software.amazon.awssdk.services.ssm.model.OpsFilterOperatorType.NOT_EQUAL =>
      val r = NotEqual
      r
    case software.amazon.awssdk.services.ssm.model.OpsFilterOperatorType.BEGIN_WITH =>
      val r = BeginWith
      r
    case software.amazon.awssdk.services.ssm.model.OpsFilterOperatorType.LESS_THAN =>
      val r = LessThan
      r
    case software.amazon.awssdk.services.ssm.model.OpsFilterOperatorType.GREATER_THAN =>
      val r = GreaterThan
      r
    case software.amazon.awssdk.services.ssm.model.OpsFilterOperatorType.EXISTS =>
      val r = Exists
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.ssm.model.OpsFilterOperatorType {
    override def unwrap
        : software.amazon.awssdk.services.ssm.model.OpsFilterOperatorType =
      software.amazon.awssdk.services.ssm.model.OpsFilterOperatorType.UNKNOWN_TO_SDK_VERSION
  }
  case object Equal extends zio.aws.ssm.model.OpsFilterOperatorType {
    override def unwrap
        : software.amazon.awssdk.services.ssm.model.OpsFilterOperatorType =
      software.amazon.awssdk.services.ssm.model.OpsFilterOperatorType.EQUAL
  }
  case object NotEqual extends zio.aws.ssm.model.OpsFilterOperatorType {
    override def unwrap
        : software.amazon.awssdk.services.ssm.model.OpsFilterOperatorType =
      software.amazon.awssdk.services.ssm.model.OpsFilterOperatorType.NOT_EQUAL
  }
  case object BeginWith extends zio.aws.ssm.model.OpsFilterOperatorType {
    override def unwrap
        : software.amazon.awssdk.services.ssm.model.OpsFilterOperatorType =
      software.amazon.awssdk.services.ssm.model.OpsFilterOperatorType.BEGIN_WITH
  }
  case object LessThan extends zio.aws.ssm.model.OpsFilterOperatorType {
    override def unwrap
        : software.amazon.awssdk.services.ssm.model.OpsFilterOperatorType =
      software.amazon.awssdk.services.ssm.model.OpsFilterOperatorType.LESS_THAN
  }
  case object GreaterThan extends zio.aws.ssm.model.OpsFilterOperatorType {
    override def unwrap
        : software.amazon.awssdk.services.ssm.model.OpsFilterOperatorType =
      software.amazon.awssdk.services.ssm.model.OpsFilterOperatorType.GREATER_THAN
  }
  case object Exists extends zio.aws.ssm.model.OpsFilterOperatorType {
    override def unwrap
        : software.amazon.awssdk.services.ssm.model.OpsFilterOperatorType =
      software.amazon.awssdk.services.ssm.model.OpsFilterOperatorType.EXISTS
  }
}
