package zio.aws.ssm.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.ssm.model.primitives.{
  PSParameterName,
  PSParameterVersion,
  PSParameterSelector,
  DateTime,
  PSParameterValue,
  ParameterDataType
}
import scala.jdk.CollectionConverters.*
final case class Parameter(
    name: Optional[PSParameterName] = Optional.Absent,
    `type`: Optional[zio.aws.ssm.model.ParameterType] = Optional.Absent,
    value: Optional[PSParameterValue] = Optional.Absent,
    version: Optional[PSParameterVersion] = Optional.Absent,
    selector: Optional[PSParameterSelector] = Optional.Absent,
    sourceResult: Optional[String] = Optional.Absent,
    lastModifiedDate: Optional[DateTime] = Optional.Absent,
    arn: Optional[String] = Optional.Absent,
    dataType: Optional[ParameterDataType] = Optional.Absent
) {
  def buildAwsValue(): software.amazon.awssdk.services.ssm.model.Parameter = {
    import Parameter.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ssm.model.Parameter
      .builder()
      .optionallyWith(
        name.map(value => PSParameterName.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(`type`.map(value => value.unwrap))(_.`type`)
      .optionallyWith(
        value.map(value => PSParameterValue.unwrap(value): java.lang.String)
      )(_.value)
      .optionallyWith(
        version.map(value => PSParameterVersion.unwrap(value): java.lang.Long)
      )(_.version)
      .optionallyWith(
        selector.map(value =>
          PSParameterSelector.unwrap(value): java.lang.String
        )
      )(_.selector)
      .optionallyWith(sourceResult.map(value => value: java.lang.String))(
        _.sourceResult
      )
      .optionallyWith(
        lastModifiedDate.map(value => DateTime.unwrap(value): Instant)
      )(_.lastModifiedDate)
      .optionallyWith(arn.map(value => value: java.lang.String))(_.arn)
      .optionallyWith(
        dataType.map(value => ParameterDataType.unwrap(value): java.lang.String)
      )(_.dataType)
      .build()
  }
  def asReadOnly: zio.aws.ssm.model.Parameter.ReadOnly =
    zio.aws.ssm.model.Parameter.wrap(buildAwsValue())
}
object Parameter {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.ssm.model.Parameter] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ssm.model.Parameter = zio.aws.ssm.model.Parameter(
      name.map(value => value),
      `type`.map(value => value),
      value.map(value => value),
      version.map(value => value),
      selector.map(value => value),
      sourceResult.map(value => value),
      lastModifiedDate.map(value => value),
      arn.map(value => value),
      dataType.map(value => value)
    )
    def name: Optional[PSParameterName]
    def `type`: Optional[zio.aws.ssm.model.ParameterType]
    def value: Optional[PSParameterValue]
    def version: Optional[PSParameterVersion]
    def selector: Optional[PSParameterSelector]
    def sourceResult: Optional[String]
    def lastModifiedDate: Optional[DateTime]
    def arn: Optional[String]
    def dataType: Optional[ParameterDataType]
    def getName: ZIO[Any, AwsError, PSParameterName] =
      AwsError.unwrapOptionField("name", name)
    def getType: ZIO[Any, AwsError, zio.aws.ssm.model.ParameterType] =
      AwsError.unwrapOptionField("type", `type`)
    def getValue: ZIO[Any, AwsError, PSParameterValue] =
      AwsError.unwrapOptionField("value", value)
    def getVersion: ZIO[Any, AwsError, PSParameterVersion] =
      AwsError.unwrapOptionField("version", version)
    def getSelector: ZIO[Any, AwsError, PSParameterSelector] =
      AwsError.unwrapOptionField("selector", selector)
    def getSourceResult: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("sourceResult", sourceResult)
    def getLastModifiedDate: ZIO[Any, AwsError, DateTime] =
      AwsError.unwrapOptionField("lastModifiedDate", lastModifiedDate)
    def getArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("arn", arn)
    def getDataType: ZIO[Any, AwsError, ParameterDataType] =
      AwsError.unwrapOptionField("dataType", dataType)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ssm.model.Parameter
  ) extends zio.aws.ssm.model.Parameter.ReadOnly {
    override val name: Optional[PSParameterName] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => zio.aws.ssm.model.primitives.PSParameterName(value))
    override val `type`: Optional[zio.aws.ssm.model.ParameterType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.`type`())
        .map(value => zio.aws.ssm.model.ParameterType.wrap(value))
    override val value: Optional[PSParameterValue] = zio.aws.core.internal
      .optionalFromNullable(impl.value())
      .map(value => zio.aws.ssm.model.primitives.PSParameterValue(value))
    override val version: Optional[PSParameterVersion] = zio.aws.core.internal
      .optionalFromNullable(impl.version())
      .map(value => zio.aws.ssm.model.primitives.PSParameterVersion(value))
    override val selector: Optional[PSParameterSelector] = zio.aws.core.internal
      .optionalFromNullable(impl.selector())
      .map(value => zio.aws.ssm.model.primitives.PSParameterSelector(value))
    override val sourceResult: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.sourceResult())
      .map(value => value: String)
    override val lastModifiedDate: Optional[DateTime] = zio.aws.core.internal
      .optionalFromNullable(impl.lastModifiedDate())
      .map(value => zio.aws.ssm.model.primitives.DateTime(value))
    override val arn: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.arn())
      .map(value => value: String)
    override val dataType: Optional[ParameterDataType] = zio.aws.core.internal
      .optionalFromNullable(impl.dataType())
      .map(value => zio.aws.ssm.model.primitives.ParameterDataType(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ssm.model.Parameter
  ): zio.aws.ssm.model.Parameter.ReadOnly = new Wrapper(impl)
}
