package zio.aws.ssm.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ParameterInlinePolicy(
    policyText: Optional[String] = Optional.Absent,
    policyType: Optional[String] = Optional.Absent,
    policyStatus: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ssm.model.ParameterInlinePolicy = {
    import ParameterInlinePolicy.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ssm.model.ParameterInlinePolicy
      .builder()
      .optionallyWith(policyText.map(value => value: java.lang.String))(
        _.policyText
      )
      .optionallyWith(policyType.map(value => value: java.lang.String))(
        _.policyType
      )
      .optionallyWith(policyStatus.map(value => value: java.lang.String))(
        _.policyStatus
      )
      .build()
  }
  def asReadOnly: zio.aws.ssm.model.ParameterInlinePolicy.ReadOnly =
    zio.aws.ssm.model.ParameterInlinePolicy.wrap(buildAwsValue())
}
object ParameterInlinePolicy {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ssm.model.ParameterInlinePolicy
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ssm.model.ParameterInlinePolicy =
      zio.aws.ssm.model.ParameterInlinePolicy(
        policyText.map(value => value),
        policyType.map(value => value),
        policyStatus.map(value => value)
      )
    def policyText: Optional[String]
    def policyType: Optional[String]
    def policyStatus: Optional[String]
    def getPolicyText: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("policyText", policyText)
    def getPolicyType: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("policyType", policyType)
    def getPolicyStatus: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("policyStatus", policyStatus)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ssm.model.ParameterInlinePolicy
  ) extends zio.aws.ssm.model.ParameterInlinePolicy.ReadOnly {
    override val policyText: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.policyText())
      .map(value => value: String)
    override val policyType: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.policyType())
      .map(value => value: String)
    override val policyStatus: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.policyStatus())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ssm.model.ParameterInlinePolicy
  ): zio.aws.ssm.model.ParameterInlinePolicy.ReadOnly = new Wrapper(impl)
}
