package zio.aws.ssm.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import zio.aws.ssm.model.primitives.AutomationActionName
import scala.jdk.CollectionConverters.*
final case class ParentStepDetails(
    stepExecutionId: Optional[String] = Optional.Absent,
    stepName: Optional[String] = Optional.Absent,
    action: Optional[AutomationActionName] = Optional.Absent,
    iteration: Optional[zio.aws.ssm.model.primitives.Integer] = Optional.Absent,
    iteratorValue: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ssm.model.ParentStepDetails = {
    import ParentStepDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ssm.model.ParentStepDetails
      .builder()
      .optionallyWith(stepExecutionId.map(value => value: java.lang.String))(
        _.stepExecutionId
      )
      .optionallyWith(stepName.map(value => value: java.lang.String))(
        _.stepName
      )
      .optionallyWith(
        action.map(value =>
          AutomationActionName.unwrap(value): java.lang.String
        )
      )(_.action)
      .optionallyWith(iteration.map(value => value: Integer))(_.iteration)
      .optionallyWith(iteratorValue.map(value => value: java.lang.String))(
        _.iteratorValue
      )
      .build()
  }
  def asReadOnly: zio.aws.ssm.model.ParentStepDetails.ReadOnly =
    zio.aws.ssm.model.ParentStepDetails.wrap(buildAwsValue())
}
object ParentStepDetails {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ssm.model.ParentStepDetails
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ssm.model.ParentStepDetails =
      zio.aws.ssm.model.ParentStepDetails(
        stepExecutionId.map(value => value),
        stepName.map(value => value),
        action.map(value => value),
        iteration.map(value => value),
        iteratorValue.map(value => value)
      )
    def stepExecutionId: Optional[String]
    def stepName: Optional[String]
    def action: Optional[AutomationActionName]
    def iteration: Optional[zio.aws.ssm.model.primitives.Integer]
    def iteratorValue: Optional[String]
    def getStepExecutionId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("stepExecutionId", stepExecutionId)
    def getStepName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("stepName", stepName)
    def getAction: ZIO[Any, AwsError, AutomationActionName] =
      AwsError.unwrapOptionField("action", action)
    def getIteration: ZIO[Any, AwsError, zio.aws.ssm.model.primitives.Integer] =
      AwsError.unwrapOptionField("iteration", iteration)
    def getIteratorValue: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("iteratorValue", iteratorValue)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ssm.model.ParentStepDetails
  ) extends zio.aws.ssm.model.ParentStepDetails.ReadOnly {
    override val stepExecutionId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.stepExecutionId())
      .map(value => value: String)
    override val stepName: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.stepName())
      .map(value => value: String)
    override val action: Optional[AutomationActionName] = zio.aws.core.internal
      .optionalFromNullable(impl.action())
      .map(value => zio.aws.ssm.model.primitives.AutomationActionName(value))
    override val iteration: Optional[zio.aws.ssm.model.primitives.Integer] =
      zio.aws.core.internal
        .optionalFromNullable(impl.iteration())
        .map(value => value: zio.aws.ssm.model.primitives.Integer)
    override val iteratorValue: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.iteratorValue())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ssm.model.ParentStepDetails
  ): zio.aws.ssm.model.ParentStepDetails.ReadOnly = new Wrapper(impl)
}
