package zio.aws.ssm.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class PatchRuleGroup(
    patchRules: Iterable[zio.aws.ssm.model.PatchRule]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ssm.model.PatchRuleGroup = {
    import PatchRuleGroup.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ssm.model.PatchRuleGroup
      .builder()
      .patchRules(patchRules.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.ssm.model.PatchRuleGroup.ReadOnly =
    zio.aws.ssm.model.PatchRuleGroup.wrap(buildAwsValue())
}
object PatchRuleGroup {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ssm.model.PatchRuleGroup
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ssm.model.PatchRuleGroup =
      zio.aws.ssm.model.PatchRuleGroup(patchRules.map { item =>
        item.asEditable
      })
    def patchRules: List[zio.aws.ssm.model.PatchRule.ReadOnly]
    def getPatchRules
        : ZIO[Any, Nothing, List[zio.aws.ssm.model.PatchRule.ReadOnly]] =
      ZIO.succeed(patchRules)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ssm.model.PatchRuleGroup
  ) extends zio.aws.ssm.model.PatchRuleGroup.ReadOnly {
    override val patchRules: List[zio.aws.ssm.model.PatchRule.ReadOnly] = impl
      .patchRules()
      .asScala
      .map { item =>
        zio.aws.ssm.model.PatchRule.wrap(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.ssm.model.PatchRuleGroup
  ): zio.aws.ssm.model.PatchRuleGroup.ReadOnly = new Wrapper(impl)
}
