package zio.aws.ssm.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ProgressCounters(
    totalSteps: Optional[zio.aws.ssm.model.primitives.Integer] =
      Optional.Absent,
    successSteps: Optional[zio.aws.ssm.model.primitives.Integer] =
      Optional.Absent,
    failedSteps: Optional[zio.aws.ssm.model.primitives.Integer] =
      Optional.Absent,
    cancelledSteps: Optional[zio.aws.ssm.model.primitives.Integer] =
      Optional.Absent,
    timedOutSteps: Optional[zio.aws.ssm.model.primitives.Integer] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ssm.model.ProgressCounters = {
    import ProgressCounters.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ssm.model.ProgressCounters
      .builder()
      .optionallyWith(totalSteps.map(value => value: Integer))(_.totalSteps)
      .optionallyWith(successSteps.map(value => value: Integer))(_.successSteps)
      .optionallyWith(failedSteps.map(value => value: Integer))(_.failedSteps)
      .optionallyWith(cancelledSteps.map(value => value: Integer))(
        _.cancelledSteps
      )
      .optionallyWith(timedOutSteps.map(value => value: Integer))(
        _.timedOutSteps
      )
      .build()
  }
  def asReadOnly: zio.aws.ssm.model.ProgressCounters.ReadOnly =
    zio.aws.ssm.model.ProgressCounters.wrap(buildAwsValue())
}
object ProgressCounters {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ssm.model.ProgressCounters
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ssm.model.ProgressCounters =
      zio.aws.ssm.model.ProgressCounters(
        totalSteps.map(value => value),
        successSteps.map(value => value),
        failedSteps.map(value => value),
        cancelledSteps.map(value => value),
        timedOutSteps.map(value => value)
      )
    def totalSteps: Optional[zio.aws.ssm.model.primitives.Integer]
    def successSteps: Optional[zio.aws.ssm.model.primitives.Integer]
    def failedSteps: Optional[zio.aws.ssm.model.primitives.Integer]
    def cancelledSteps: Optional[zio.aws.ssm.model.primitives.Integer]
    def timedOutSteps: Optional[zio.aws.ssm.model.primitives.Integer]
    def getTotalSteps
        : ZIO[Any, AwsError, zio.aws.ssm.model.primitives.Integer] =
      AwsError.unwrapOptionField("totalSteps", totalSteps)
    def getSuccessSteps
        : ZIO[Any, AwsError, zio.aws.ssm.model.primitives.Integer] =
      AwsError.unwrapOptionField("successSteps", successSteps)
    def getFailedSteps
        : ZIO[Any, AwsError, zio.aws.ssm.model.primitives.Integer] =
      AwsError.unwrapOptionField("failedSteps", failedSteps)
    def getCancelledSteps
        : ZIO[Any, AwsError, zio.aws.ssm.model.primitives.Integer] =
      AwsError.unwrapOptionField("cancelledSteps", cancelledSteps)
    def getTimedOutSteps
        : ZIO[Any, AwsError, zio.aws.ssm.model.primitives.Integer] =
      AwsError.unwrapOptionField("timedOutSteps", timedOutSteps)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ssm.model.ProgressCounters
  ) extends zio.aws.ssm.model.ProgressCounters.ReadOnly {
    override val totalSteps: Optional[zio.aws.ssm.model.primitives.Integer] =
      zio.aws.core.internal
        .optionalFromNullable(impl.totalSteps())
        .map(value => value: zio.aws.ssm.model.primitives.Integer)
    override val successSteps: Optional[zio.aws.ssm.model.primitives.Integer] =
      zio.aws.core.internal
        .optionalFromNullable(impl.successSteps())
        .map(value => value: zio.aws.ssm.model.primitives.Integer)
    override val failedSteps: Optional[zio.aws.ssm.model.primitives.Integer] =
      zio.aws.core.internal
        .optionalFromNullable(impl.failedSteps())
        .map(value => value: zio.aws.ssm.model.primitives.Integer)
    override val cancelledSteps
        : Optional[zio.aws.ssm.model.primitives.Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.cancelledSteps())
      .map(value => value: zio.aws.ssm.model.primitives.Integer)
    override val timedOutSteps: Optional[zio.aws.ssm.model.primitives.Integer] =
      zio.aws.core.internal
        .optionalFromNullable(impl.timedOutSteps())
        .map(value => value: zio.aws.ssm.model.primitives.Integer)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ssm.model.ProgressCounters
  ): zio.aws.ssm.model.ProgressCounters.ReadOnly = new Wrapper(impl)
}
