package zio.aws.ssm.model
import zio.aws.ssm.model.primitives.{PolicyHash, PolicyId}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class PutResourcePolicyResponse(
    policyId: Optional[PolicyId] = Optional.Absent,
    policyHash: Optional[PolicyHash] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ssm.model.PutResourcePolicyResponse = {
    import PutResourcePolicyResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ssm.model.PutResourcePolicyResponse
      .builder()
      .optionallyWith(
        policyId.map(value => PolicyId.unwrap(value): java.lang.String)
      )(_.policyId)
      .optionallyWith(
        policyHash.map(value => PolicyHash.unwrap(value): java.lang.String)
      )(_.policyHash)
      .build()
  }
  def asReadOnly: zio.aws.ssm.model.PutResourcePolicyResponse.ReadOnly =
    zio.aws.ssm.model.PutResourcePolicyResponse.wrap(buildAwsValue())
}
object PutResourcePolicyResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ssm.model.PutResourcePolicyResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ssm.model.PutResourcePolicyResponse =
      zio.aws.ssm.model.PutResourcePolicyResponse(
        policyId.map(value => value),
        policyHash.map(value => value)
      )
    def policyId: Optional[PolicyId]
    def policyHash: Optional[PolicyHash]
    def getPolicyId: ZIO[Any, AwsError, PolicyId] =
      AwsError.unwrapOptionField("policyId", policyId)
    def getPolicyHash: ZIO[Any, AwsError, PolicyHash] =
      AwsError.unwrapOptionField("policyHash", policyHash)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ssm.model.PutResourcePolicyResponse
  ) extends zio.aws.ssm.model.PutResourcePolicyResponse.ReadOnly {
    override val policyId: Optional[PolicyId] = zio.aws.core.internal
      .optionalFromNullable(impl.policyId())
      .map(value => zio.aws.ssm.model.primitives.PolicyId(value))
    override val policyHash: Optional[PolicyHash] = zio.aws.core.internal
      .optionalFromNullable(impl.policyHash())
      .map(value => zio.aws.ssm.model.primitives.PolicyHash(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ssm.model.PutResourcePolicyResponse
  ): zio.aws.ssm.model.PutResourcePolicyResponse.ReadOnly = new Wrapper(impl)
}
