package zio.aws.ssm.model
import zio.aws.ssm.model.primitives.BaselineId
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class RegisterDefaultPatchBaselineResponse(
    baselineId: Optional[BaselineId] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ssm.model.RegisterDefaultPatchBaselineResponse = {
    import RegisterDefaultPatchBaselineResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ssm.model.RegisterDefaultPatchBaselineResponse
      .builder()
      .optionallyWith(
        baselineId.map(value => BaselineId.unwrap(value): java.lang.String)
      )(_.baselineId)
      .build()
  }
  def asReadOnly
      : zio.aws.ssm.model.RegisterDefaultPatchBaselineResponse.ReadOnly =
    zio.aws.ssm.model.RegisterDefaultPatchBaselineResponse.wrap(buildAwsValue())
}
object RegisterDefaultPatchBaselineResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ssm.model.RegisterDefaultPatchBaselineResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ssm.model.RegisterDefaultPatchBaselineResponse =
      zio.aws.ssm.model
        .RegisterDefaultPatchBaselineResponse(baselineId.map(value => value))
    def baselineId: Optional[BaselineId]
    def getBaselineId: ZIO[Any, AwsError, BaselineId] =
      AwsError.unwrapOptionField("baselineId", baselineId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ssm.model.RegisterDefaultPatchBaselineResponse
  ) extends zio.aws.ssm.model.RegisterDefaultPatchBaselineResponse.ReadOnly {
    override val baselineId: Optional[BaselineId] = zio.aws.core.internal
      .optionalFromNullable(impl.baselineId())
      .map(value => zio.aws.ssm.model.primitives.BaselineId(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ssm.model.RegisterDefaultPatchBaselineResponse
  ): zio.aws.ssm.model.RegisterDefaultPatchBaselineResponse.ReadOnly =
    new Wrapper(impl)
}
