package zio.aws.ssm.model
import zio.aws.ssm.model.primitives.{TagKey, ResourceId}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class RemoveTagsFromResourceRequest(
    resourceType: zio.aws.ssm.model.ResourceTypeForTagging,
    resourceId: ResourceId,
    tagKeys: Iterable[TagKey]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ssm.model.RemoveTagsFromResourceRequest = {
    import RemoveTagsFromResourceRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ssm.model.RemoveTagsFromResourceRequest
      .builder()
      .resourceType(resourceType.unwrap)
      .resourceId(ResourceId.unwrap(resourceId): java.lang.String)
      .tagKeys(tagKeys.map { item =>
        TagKey.unwrap(item): java.lang.String
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.ssm.model.RemoveTagsFromResourceRequest.ReadOnly =
    zio.aws.ssm.model.RemoveTagsFromResourceRequest.wrap(buildAwsValue())
}
object RemoveTagsFromResourceRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ssm.model.RemoveTagsFromResourceRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ssm.model.RemoveTagsFromResourceRequest =
      zio.aws.ssm.model
        .RemoveTagsFromResourceRequest(resourceType, resourceId, tagKeys)
    def resourceType: zio.aws.ssm.model.ResourceTypeForTagging
    def resourceId: ResourceId
    def tagKeys: List[TagKey]
    def getResourceType
        : ZIO[Any, Nothing, zio.aws.ssm.model.ResourceTypeForTagging] =
      ZIO.succeed(resourceType)
    def getResourceId: ZIO[Any, Nothing, ResourceId] = ZIO.succeed(resourceId)
    def getTagKeys: ZIO[Any, Nothing, List[TagKey]] = ZIO.succeed(tagKeys)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ssm.model.RemoveTagsFromResourceRequest
  ) extends zio.aws.ssm.model.RemoveTagsFromResourceRequest.ReadOnly {
    override val resourceType: zio.aws.ssm.model.ResourceTypeForTagging =
      zio.aws.ssm.model.ResourceTypeForTagging.wrap(impl.resourceType())
    override val resourceId: ResourceId =
      zio.aws.ssm.model.primitives.ResourceId(impl.resourceId())
    override val tagKeys: List[TagKey] = impl
      .tagKeys()
      .asScala
      .map { item =>
        zio.aws.ssm.model.primitives.TagKey(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.ssm.model.RemoveTagsFromResourceRequest
  ): zio.aws.ssm.model.RemoveTagsFromResourceRequest.ReadOnly = new Wrapper(
    impl
  )
}
