package zio.aws.ssm.model
import zio.aws.ssm.model.primitives.{
  ResourceDataSyncState,
  ResourceDataSyncIncludeFutureRegions,
  ResourceDataSyncEnableAllOpsDataSources,
  ResourceDataSyncSourceRegion,
  ResourceDataSyncSourceType
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ResourceDataSyncSourceWithState(
    sourceType: Optional[ResourceDataSyncSourceType] = Optional.Absent,
    awsOrganizationsSource: Optional[
      zio.aws.ssm.model.ResourceDataSyncAwsOrganizationsSource
    ] = Optional.Absent,
    sourceRegions: Optional[Iterable[ResourceDataSyncSourceRegion]] =
      Optional.Absent,
    includeFutureRegions: Optional[ResourceDataSyncIncludeFutureRegions] =
      Optional.Absent,
    state: Optional[ResourceDataSyncState] = Optional.Absent,
    enableAllOpsDataSources: Optional[ResourceDataSyncEnableAllOpsDataSources] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ssm.model.ResourceDataSyncSourceWithState = {
    import ResourceDataSyncSourceWithState.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ssm.model.ResourceDataSyncSourceWithState
      .builder()
      .optionallyWith(
        sourceType.map(value =>
          ResourceDataSyncSourceType.unwrap(value): java.lang.String
        )
      )(_.sourceType)
      .optionallyWith(
        awsOrganizationsSource.map(value => value.buildAwsValue())
      )(_.awsOrganizationsSource)
      .optionallyWith(
        sourceRegions.map(value =>
          value.map { item =>
            ResourceDataSyncSourceRegion.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.sourceRegions)
      .optionallyWith(
        includeFutureRegions.map(value =>
          ResourceDataSyncIncludeFutureRegions.unwrap(value): java.lang.Boolean
        )
      )(_.includeFutureRegions)
      .optionallyWith(
        state.map(value =>
          ResourceDataSyncState.unwrap(value): java.lang.String
        )
      )(_.state)
      .optionallyWith(
        enableAllOpsDataSources.map(value =>
          ResourceDataSyncEnableAllOpsDataSources.unwrap(
            value
          ): java.lang.Boolean
        )
      )(_.enableAllOpsDataSources)
      .build()
  }
  def asReadOnly: zio.aws.ssm.model.ResourceDataSyncSourceWithState.ReadOnly =
    zio.aws.ssm.model.ResourceDataSyncSourceWithState.wrap(buildAwsValue())
}
object ResourceDataSyncSourceWithState {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ssm.model.ResourceDataSyncSourceWithState
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ssm.model.ResourceDataSyncSourceWithState =
      zio.aws.ssm.model.ResourceDataSyncSourceWithState(
        sourceType.map(value => value),
        awsOrganizationsSource.map(value => value.asEditable),
        sourceRegions.map(value => value),
        includeFutureRegions.map(value => value),
        state.map(value => value),
        enableAllOpsDataSources.map(value => value)
      )
    def sourceType: Optional[ResourceDataSyncSourceType]
    def awsOrganizationsSource: Optional[
      zio.aws.ssm.model.ResourceDataSyncAwsOrganizationsSource.ReadOnly
    ]
    def sourceRegions: Optional[List[ResourceDataSyncSourceRegion]]
    def includeFutureRegions: Optional[ResourceDataSyncIncludeFutureRegions]
    def state: Optional[ResourceDataSyncState]
    def enableAllOpsDataSources
        : Optional[ResourceDataSyncEnableAllOpsDataSources]
    def getSourceType: ZIO[Any, AwsError, ResourceDataSyncSourceType] =
      AwsError.unwrapOptionField("sourceType", sourceType)
    def getAwsOrganizationsSource: ZIO[
      Any,
      AwsError,
      zio.aws.ssm.model.ResourceDataSyncAwsOrganizationsSource.ReadOnly
    ] = AwsError.unwrapOptionField(
      "awsOrganizationsSource",
      awsOrganizationsSource
    )
    def getSourceRegions
        : ZIO[Any, AwsError, List[ResourceDataSyncSourceRegion]] =
      AwsError.unwrapOptionField("sourceRegions", sourceRegions)
    def getIncludeFutureRegions
        : ZIO[Any, AwsError, ResourceDataSyncIncludeFutureRegions] =
      AwsError.unwrapOptionField("includeFutureRegions", includeFutureRegions)
    def getState: ZIO[Any, AwsError, ResourceDataSyncState] =
      AwsError.unwrapOptionField("state", state)
    def getEnableAllOpsDataSources
        : ZIO[Any, AwsError, ResourceDataSyncEnableAllOpsDataSources] = AwsError
      .unwrapOptionField("enableAllOpsDataSources", enableAllOpsDataSources)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ssm.model.ResourceDataSyncSourceWithState
  ) extends zio.aws.ssm.model.ResourceDataSyncSourceWithState.ReadOnly {
    override val sourceType: Optional[ResourceDataSyncSourceType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.sourceType())
        .map(value =>
          zio.aws.ssm.model.primitives.ResourceDataSyncSourceType(value)
        )
    override val awsOrganizationsSource: Optional[
      zio.aws.ssm.model.ResourceDataSyncAwsOrganizationsSource.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.awsOrganizationsSource())
      .map(value =>
        zio.aws.ssm.model.ResourceDataSyncAwsOrganizationsSource.wrap(value)
      )
    override val sourceRegions: Optional[List[ResourceDataSyncSourceRegion]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.sourceRegions())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ssm.model.primitives.ResourceDataSyncSourceRegion(item)
          }.toList
        )
    override val includeFutureRegions
        : Optional[ResourceDataSyncIncludeFutureRegions] = zio.aws.core.internal
      .optionalFromNullable(impl.includeFutureRegions())
      .map(value =>
        zio.aws.ssm.model.primitives.ResourceDataSyncIncludeFutureRegions(value)
      )
    override val state: Optional[ResourceDataSyncState] = zio.aws.core.internal
      .optionalFromNullable(impl.state())
      .map(value => zio.aws.ssm.model.primitives.ResourceDataSyncState(value))
    override val enableAllOpsDataSources
        : Optional[ResourceDataSyncEnableAllOpsDataSources] =
      zio.aws.core.internal
        .optionalFromNullable(impl.enableAllOpsDataSources())
        .map(value =>
          zio.aws.ssm.model.primitives
            .ResourceDataSyncEnableAllOpsDataSources(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ssm.model.ResourceDataSyncSourceWithState
  ): zio.aws.ssm.model.ResourceDataSyncSourceWithState.ReadOnly = new Wrapper(
    impl
  )
}
