package zio.aws.ssm.model
import zio.aws.ssm.model.primitives.InventoryItemTypeName
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class ResultAttribute(typeName: InventoryItemTypeName) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ssm.model.ResultAttribute = {
    import ResultAttribute.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ssm.model.ResultAttribute
      .builder()
      .typeName(InventoryItemTypeName.unwrap(typeName): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.ssm.model.ResultAttribute.ReadOnly =
    zio.aws.ssm.model.ResultAttribute.wrap(buildAwsValue())
}
object ResultAttribute {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ssm.model.ResultAttribute
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ssm.model.ResultAttribute =
      zio.aws.ssm.model.ResultAttribute(typeName)
    def typeName: InventoryItemTypeName
    def getTypeName: ZIO[Any, Nothing, InventoryItemTypeName] =
      ZIO.succeed(typeName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ssm.model.ResultAttribute
  ) extends zio.aws.ssm.model.ResultAttribute.ReadOnly {
    override val typeName: InventoryItemTypeName =
      zio.aws.ssm.model.primitives.InventoryItemTypeName(impl.typeName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.ssm.model.ResultAttribute
  ): zio.aws.ssm.model.ResultAttribute.ReadOnly = new Wrapper(impl)
}
