package zio.aws.ssm.model
import zio.aws.ssm.model.primitives.{
  MaintenanceWindowStringDateTime,
  MaintenanceWindowName,
  MaintenanceWindowId
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ScheduledWindowExecution(
    windowId: Optional[MaintenanceWindowId] = Optional.Absent,
    name: Optional[MaintenanceWindowName] = Optional.Absent,
    executionTime: Optional[MaintenanceWindowStringDateTime] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ssm.model.ScheduledWindowExecution = {
    import ScheduledWindowExecution.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ssm.model.ScheduledWindowExecution
      .builder()
      .optionallyWith(
        windowId.map(value =>
          MaintenanceWindowId.unwrap(value): java.lang.String
        )
      )(_.windowId)
      .optionallyWith(
        name.map(value => MaintenanceWindowName.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(
        executionTime.map(value =>
          MaintenanceWindowStringDateTime.unwrap(value): java.lang.String
        )
      )(_.executionTime)
      .build()
  }
  def asReadOnly: zio.aws.ssm.model.ScheduledWindowExecution.ReadOnly =
    zio.aws.ssm.model.ScheduledWindowExecution.wrap(buildAwsValue())
}
object ScheduledWindowExecution {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ssm.model.ScheduledWindowExecution
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ssm.model.ScheduledWindowExecution =
      zio.aws.ssm.model.ScheduledWindowExecution(
        windowId.map(value => value),
        name.map(value => value),
        executionTime.map(value => value)
      )
    def windowId: Optional[MaintenanceWindowId]
    def name: Optional[MaintenanceWindowName]
    def executionTime: Optional[MaintenanceWindowStringDateTime]
    def getWindowId: ZIO[Any, AwsError, MaintenanceWindowId] =
      AwsError.unwrapOptionField("windowId", windowId)
    def getName: ZIO[Any, AwsError, MaintenanceWindowName] =
      AwsError.unwrapOptionField("name", name)
    def getExecutionTime: ZIO[Any, AwsError, MaintenanceWindowStringDateTime] =
      AwsError.unwrapOptionField("executionTime", executionTime)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ssm.model.ScheduledWindowExecution
  ) extends zio.aws.ssm.model.ScheduledWindowExecution.ReadOnly {
    override val windowId: Optional[MaintenanceWindowId] = zio.aws.core.internal
      .optionalFromNullable(impl.windowId())
      .map(value => zio.aws.ssm.model.primitives.MaintenanceWindowId(value))
    override val name: Optional[MaintenanceWindowName] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => zio.aws.ssm.model.primitives.MaintenanceWindowName(value))
    override val executionTime: Optional[MaintenanceWindowStringDateTime] =
      zio.aws.core.internal
        .optionalFromNullable(impl.executionTime())
        .map(value =>
          zio.aws.ssm.model.primitives.MaintenanceWindowStringDateTime(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ssm.model.ScheduledWindowExecution
  ): zio.aws.ssm.model.ScheduledWindowExecution.ReadOnly = new Wrapper(impl)
}
