package zio.aws.ssm.model
import zio.aws.ssm.model.primitives.AssociationId
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class StartAssociationsOnceRequest(
    associationIds: Iterable[AssociationId]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ssm.model.StartAssociationsOnceRequest = {
    import StartAssociationsOnceRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ssm.model.StartAssociationsOnceRequest
      .builder()
      .associationIds(associationIds.map { item =>
        AssociationId.unwrap(item): java.lang.String
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.ssm.model.StartAssociationsOnceRequest.ReadOnly =
    zio.aws.ssm.model.StartAssociationsOnceRequest.wrap(buildAwsValue())
}
object StartAssociationsOnceRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ssm.model.StartAssociationsOnceRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ssm.model.StartAssociationsOnceRequest =
      zio.aws.ssm.model.StartAssociationsOnceRequest(associationIds)
    def associationIds: List[AssociationId]
    def getAssociationIds: ZIO[Any, Nothing, List[AssociationId]] =
      ZIO.succeed(associationIds)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ssm.model.StartAssociationsOnceRequest
  ) extends zio.aws.ssm.model.StartAssociationsOnceRequest.ReadOnly {
    override val associationIds: List[AssociationId] = impl
      .associationIds()
      .asScala
      .map { item =>
        zio.aws.ssm.model.primitives.AssociationId(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.ssm.model.StartAssociationsOnceRequest
  ): zio.aws.ssm.model.StartAssociationsOnceRequest.ReadOnly = new Wrapper(impl)
}
