package zio.aws.ssm.model
import scala.jdk.CollectionConverters.*
sealed trait StepExecutionFilterKey {
  def unwrap: software.amazon.awssdk.services.ssm.model.StepExecutionFilterKey
}
object StepExecutionFilterKey {
  def wrap(
      value: software.amazon.awssdk.services.ssm.model.StepExecutionFilterKey
  ): zio.aws.ssm.model.StepExecutionFilterKey = value match {
    case software.amazon.awssdk.services.ssm.model.StepExecutionFilterKey.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.ssm.model.StepExecutionFilterKey.START_TIME_BEFORE =>
      val r = StartTimeBefore
      r
    case software.amazon.awssdk.services.ssm.model.StepExecutionFilterKey.START_TIME_AFTER =>
      val r = StartTimeAfter
      r
    case software.amazon.awssdk.services.ssm.model.StepExecutionFilterKey.STEP_EXECUTION_STATUS =>
      val r = StepExecutionStatus
      r
    case software.amazon.awssdk.services.ssm.model.StepExecutionFilterKey.STEP_EXECUTION_ID =>
      val r = StepExecutionId
      r
    case software.amazon.awssdk.services.ssm.model.StepExecutionFilterKey.STEP_NAME =>
      val r = StepName
      r
    case software.amazon.awssdk.services.ssm.model.StepExecutionFilterKey.ACTION =>
      val r = Action
      r
    case software.amazon.awssdk.services.ssm.model.StepExecutionFilterKey.PARENT_STEP_EXECUTION_ID =>
      val r = ParentStepExecutionId
      r
    case software.amazon.awssdk.services.ssm.model.StepExecutionFilterKey.PARENT_STEP_ITERATION =>
      val r = ParentStepIteration
      r
    case software.amazon.awssdk.services.ssm.model.StepExecutionFilterKey.PARENT_STEP_ITERATOR_VALUE =>
      val r = ParentStepIteratorValue
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.ssm.model.StepExecutionFilterKey {
    override def unwrap
        : software.amazon.awssdk.services.ssm.model.StepExecutionFilterKey =
      software.amazon.awssdk.services.ssm.model.StepExecutionFilterKey.UNKNOWN_TO_SDK_VERSION
  }
  case object StartTimeBefore extends zio.aws.ssm.model.StepExecutionFilterKey {
    override def unwrap
        : software.amazon.awssdk.services.ssm.model.StepExecutionFilterKey =
      software.amazon.awssdk.services.ssm.model.StepExecutionFilterKey.START_TIME_BEFORE
  }
  case object StartTimeAfter extends zio.aws.ssm.model.StepExecutionFilterKey {
    override def unwrap
        : software.amazon.awssdk.services.ssm.model.StepExecutionFilterKey =
      software.amazon.awssdk.services.ssm.model.StepExecutionFilterKey.START_TIME_AFTER
  }
  case object StepExecutionStatus
      extends zio.aws.ssm.model.StepExecutionFilterKey {
    override def unwrap
        : software.amazon.awssdk.services.ssm.model.StepExecutionFilterKey =
      software.amazon.awssdk.services.ssm.model.StepExecutionFilterKey.STEP_EXECUTION_STATUS
  }
  case object StepExecutionId extends zio.aws.ssm.model.StepExecutionFilterKey {
    override def unwrap
        : software.amazon.awssdk.services.ssm.model.StepExecutionFilterKey =
      software.amazon.awssdk.services.ssm.model.StepExecutionFilterKey.STEP_EXECUTION_ID
  }
  case object StepName extends zio.aws.ssm.model.StepExecutionFilterKey {
    override def unwrap
        : software.amazon.awssdk.services.ssm.model.StepExecutionFilterKey =
      software.amazon.awssdk.services.ssm.model.StepExecutionFilterKey.STEP_NAME
  }
  case object Action extends zio.aws.ssm.model.StepExecutionFilterKey {
    override def unwrap
        : software.amazon.awssdk.services.ssm.model.StepExecutionFilterKey =
      software.amazon.awssdk.services.ssm.model.StepExecutionFilterKey.ACTION
  }
  case object ParentStepExecutionId
      extends zio.aws.ssm.model.StepExecutionFilterKey {
    override def unwrap
        : software.amazon.awssdk.services.ssm.model.StepExecutionFilterKey =
      software.amazon.awssdk.services.ssm.model.StepExecutionFilterKey.PARENT_STEP_EXECUTION_ID
  }
  case object ParentStepIteration
      extends zio.aws.ssm.model.StepExecutionFilterKey {
    override def unwrap
        : software.amazon.awssdk.services.ssm.model.StepExecutionFilterKey =
      software.amazon.awssdk.services.ssm.model.StepExecutionFilterKey.PARENT_STEP_ITERATION
  }
  case object ParentStepIteratorValue
      extends zio.aws.ssm.model.StepExecutionFilterKey {
    override def unwrap
        : software.amazon.awssdk.services.ssm.model.StepExecutionFilterKey =
      software.amazon.awssdk.services.ssm.model.StepExecutionFilterKey.PARENT_STEP_ITERATOR_VALUE
  }
}
