package zio.aws.ssm.model
import zio.aws.ssm.model.primitives.{
  Account,
  ExcludeAccount,
  Region,
  ExecutionRoleName,
  MaxConcurrency,
  MaxErrors
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class TargetLocation(
    accounts: Optional[Iterable[Account]] = Optional.Absent,
    regions: Optional[Iterable[Region]] = Optional.Absent,
    targetLocationMaxConcurrency: Optional[MaxConcurrency] = Optional.Absent,
    targetLocationMaxErrors: Optional[MaxErrors] = Optional.Absent,
    executionRoleName: Optional[ExecutionRoleName] = Optional.Absent,
    targetLocationAlarmConfiguration: Optional[
      zio.aws.ssm.model.AlarmConfiguration
    ] = Optional.Absent,
    includeChildOrganizationUnits: Optional[Boolean] = Optional.Absent,
    excludeAccounts: Optional[Iterable[ExcludeAccount]] = Optional.Absent,
    targets: Optional[Iterable[zio.aws.ssm.model.Target]] = Optional.Absent,
    targetsMaxConcurrency: Optional[MaxConcurrency] = Optional.Absent,
    targetsMaxErrors: Optional[MaxErrors] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ssm.model.TargetLocation = {
    import TargetLocation.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ssm.model.TargetLocation
      .builder()
      .optionallyWith(
        accounts.map(value =>
          value.map { item =>
            Account.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.accounts)
      .optionallyWith(
        regions.map(value =>
          value.map { item =>
            Region.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.regions)
      .optionallyWith(
        targetLocationMaxConcurrency.map(value =>
          MaxConcurrency.unwrap(value): java.lang.String
        )
      )(_.targetLocationMaxConcurrency)
      .optionallyWith(
        targetLocationMaxErrors.map(value =>
          MaxErrors.unwrap(value): java.lang.String
        )
      )(_.targetLocationMaxErrors)
      .optionallyWith(
        executionRoleName.map(value =>
          ExecutionRoleName.unwrap(value): java.lang.String
        )
      )(_.executionRoleName)
      .optionallyWith(
        targetLocationAlarmConfiguration.map(value => value.buildAwsValue())
      )(_.targetLocationAlarmConfiguration)
      .optionallyWith(
        includeChildOrganizationUnits.map(value => value: java.lang.Boolean)
      )(_.includeChildOrganizationUnits)
      .optionallyWith(
        excludeAccounts.map(value =>
          value.map { item =>
            ExcludeAccount.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.excludeAccounts)
      .optionallyWith(
        targets.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.targets)
      .optionallyWith(
        targetsMaxConcurrency.map(value =>
          MaxConcurrency.unwrap(value): java.lang.String
        )
      )(_.targetsMaxConcurrency)
      .optionallyWith(
        targetsMaxErrors.map(value => MaxErrors.unwrap(value): java.lang.String)
      )(_.targetsMaxErrors)
      .build()
  }
  def asReadOnly: zio.aws.ssm.model.TargetLocation.ReadOnly =
    zio.aws.ssm.model.TargetLocation.wrap(buildAwsValue())
}
object TargetLocation {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ssm.model.TargetLocation
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ssm.model.TargetLocation =
      zio.aws.ssm.model.TargetLocation(
        accounts.map(value => value),
        regions.map(value => value),
        targetLocationMaxConcurrency.map(value => value),
        targetLocationMaxErrors.map(value => value),
        executionRoleName.map(value => value),
        targetLocationAlarmConfiguration.map(value => value.asEditable),
        includeChildOrganizationUnits.map(value => value),
        excludeAccounts.map(value => value),
        targets.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        targetsMaxConcurrency.map(value => value),
        targetsMaxErrors.map(value => value)
      )
    def accounts: Optional[List[Account]]
    def regions: Optional[List[Region]]
    def targetLocationMaxConcurrency: Optional[MaxConcurrency]
    def targetLocationMaxErrors: Optional[MaxErrors]
    def executionRoleName: Optional[ExecutionRoleName]
    def targetLocationAlarmConfiguration
        : Optional[zio.aws.ssm.model.AlarmConfiguration.ReadOnly]
    def includeChildOrganizationUnits: Optional[Boolean]
    def excludeAccounts: Optional[List[ExcludeAccount]]
    def targets: Optional[List[zio.aws.ssm.model.Target.ReadOnly]]
    def targetsMaxConcurrency: Optional[MaxConcurrency]
    def targetsMaxErrors: Optional[MaxErrors]
    def getAccounts: ZIO[Any, AwsError, List[Account]] =
      AwsError.unwrapOptionField("accounts", accounts)
    def getRegions: ZIO[Any, AwsError, List[Region]] =
      AwsError.unwrapOptionField("regions", regions)
    def getTargetLocationMaxConcurrency: ZIO[Any, AwsError, MaxConcurrency] =
      AwsError.unwrapOptionField(
        "targetLocationMaxConcurrency",
        targetLocationMaxConcurrency
      )
    def getTargetLocationMaxErrors: ZIO[Any, AwsError, MaxErrors] = AwsError
      .unwrapOptionField("targetLocationMaxErrors", targetLocationMaxErrors)
    def getExecutionRoleName: ZIO[Any, AwsError, ExecutionRoleName] =
      AwsError.unwrapOptionField("executionRoleName", executionRoleName)
    def getTargetLocationAlarmConfiguration
        : ZIO[Any, AwsError, zio.aws.ssm.model.AlarmConfiguration.ReadOnly] =
      AwsError.unwrapOptionField(
        "targetLocationAlarmConfiguration",
        targetLocationAlarmConfiguration
      )
    def getIncludeChildOrganizationUnits: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField(
        "includeChildOrganizationUnits",
        includeChildOrganizationUnits
      )
    def getExcludeAccounts: ZIO[Any, AwsError, List[ExcludeAccount]] =
      AwsError.unwrapOptionField("excludeAccounts", excludeAccounts)
    def getTargets
        : ZIO[Any, AwsError, List[zio.aws.ssm.model.Target.ReadOnly]] =
      AwsError.unwrapOptionField("targets", targets)
    def getTargetsMaxConcurrency: ZIO[Any, AwsError, MaxConcurrency] =
      AwsError.unwrapOptionField("targetsMaxConcurrency", targetsMaxConcurrency)
    def getTargetsMaxErrors: ZIO[Any, AwsError, MaxErrors] =
      AwsError.unwrapOptionField("targetsMaxErrors", targetsMaxErrors)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ssm.model.TargetLocation
  ) extends zio.aws.ssm.model.TargetLocation.ReadOnly {
    override val accounts: Optional[List[Account]] = zio.aws.core.internal
      .optionalFromNullable(impl.accounts())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ssm.model.primitives.Account(item)
        }.toList
      )
    override val regions: Optional[List[Region]] = zio.aws.core.internal
      .optionalFromNullable(impl.regions())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ssm.model.primitives.Region(item)
        }.toList
      )
    override val targetLocationMaxConcurrency: Optional[MaxConcurrency] =
      zio.aws.core.internal
        .optionalFromNullable(impl.targetLocationMaxConcurrency())
        .map(value => zio.aws.ssm.model.primitives.MaxConcurrency(value))
    override val targetLocationMaxErrors: Optional[MaxErrors] =
      zio.aws.core.internal
        .optionalFromNullable(impl.targetLocationMaxErrors())
        .map(value => zio.aws.ssm.model.primitives.MaxErrors(value))
    override val executionRoleName: Optional[ExecutionRoleName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.executionRoleName())
        .map(value => zio.aws.ssm.model.primitives.ExecutionRoleName(value))
    override val targetLocationAlarmConfiguration
        : Optional[zio.aws.ssm.model.AlarmConfiguration.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.targetLocationAlarmConfiguration())
        .map(value => zio.aws.ssm.model.AlarmConfiguration.wrap(value))
    override val includeChildOrganizationUnits: Optional[Boolean] =
      zio.aws.core.internal
        .optionalFromNullable(impl.includeChildOrganizationUnits())
        .map(value => value: Boolean)
    override val excludeAccounts: Optional[List[ExcludeAccount]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.excludeAccounts())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ssm.model.primitives.ExcludeAccount(item)
          }.toList
        )
    override val targets: Optional[List[zio.aws.ssm.model.Target.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.targets())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ssm.model.Target.wrap(item)
          }.toList
        )
    override val targetsMaxConcurrency: Optional[MaxConcurrency] =
      zio.aws.core.internal
        .optionalFromNullable(impl.targetsMaxConcurrency())
        .map(value => zio.aws.ssm.model.primitives.MaxConcurrency(value))
    override val targetsMaxErrors: Optional[MaxErrors] = zio.aws.core.internal
      .optionalFromNullable(impl.targetsMaxErrors())
      .map(value => zio.aws.ssm.model.primitives.MaxErrors(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ssm.model.TargetLocation
  ): zio.aws.ssm.model.TargetLocation.ReadOnly = new Wrapper(impl)
}
