package zio.aws.ssm.model
import zio.aws.ssm.model.primitives.{
  BaselineDescription,
  PatchId,
  BaselineName,
  BaselineId
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class UpdatePatchBaselineRequest(
    baselineId: BaselineId,
    name: Optional[BaselineName] = Optional.Absent,
    globalFilters: Optional[zio.aws.ssm.model.PatchFilterGroup] =
      Optional.Absent,
    approvalRules: Optional[zio.aws.ssm.model.PatchRuleGroup] = Optional.Absent,
    approvedPatches: Optional[Iterable[PatchId]] = Optional.Absent,
    approvedPatchesComplianceLevel: Optional[
      zio.aws.ssm.model.PatchComplianceLevel
    ] = Optional.Absent,
    approvedPatchesEnableNonSecurity: Optional[Boolean] = Optional.Absent,
    rejectedPatches: Optional[Iterable[PatchId]] = Optional.Absent,
    rejectedPatchesAction: Optional[zio.aws.ssm.model.PatchAction] =
      Optional.Absent,
    description: Optional[BaselineDescription] = Optional.Absent,
    sources: Optional[Iterable[zio.aws.ssm.model.PatchSource]] =
      Optional.Absent,
    replace: Optional[Boolean] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ssm.model.UpdatePatchBaselineRequest = {
    import UpdatePatchBaselineRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ssm.model.UpdatePatchBaselineRequest
      .builder()
      .baselineId(BaselineId.unwrap(baselineId): java.lang.String)
      .optionallyWith(
        name.map(value => BaselineName.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(globalFilters.map(value => value.buildAwsValue()))(
        _.globalFilters
      )
      .optionallyWith(approvalRules.map(value => value.buildAwsValue()))(
        _.approvalRules
      )
      .optionallyWith(
        approvedPatches.map(value =>
          value.map { item =>
            PatchId.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.approvedPatches)
      .optionallyWith(
        approvedPatchesComplianceLevel.map(value => value.unwrap)
      )(_.approvedPatchesComplianceLevel)
      .optionallyWith(
        approvedPatchesEnableNonSecurity.map(value => value: java.lang.Boolean)
      )(_.approvedPatchesEnableNonSecurity)
      .optionallyWith(
        rejectedPatches.map(value =>
          value.map { item =>
            PatchId.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.rejectedPatches)
      .optionallyWith(rejectedPatchesAction.map(value => value.unwrap))(
        _.rejectedPatchesAction
      )
      .optionallyWith(
        description.map(value =>
          BaselineDescription.unwrap(value): java.lang.String
        )
      )(_.description)
      .optionallyWith(
        sources.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.sources)
      .optionallyWith(replace.map(value => value: java.lang.Boolean))(_.replace)
      .build()
  }
  def asReadOnly: zio.aws.ssm.model.UpdatePatchBaselineRequest.ReadOnly =
    zio.aws.ssm.model.UpdatePatchBaselineRequest.wrap(buildAwsValue())
}
object UpdatePatchBaselineRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ssm.model.UpdatePatchBaselineRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ssm.model.UpdatePatchBaselineRequest =
      zio.aws.ssm.model.UpdatePatchBaselineRequest(
        baselineId,
        name.map(value => value),
        globalFilters.map(value => value.asEditable),
        approvalRules.map(value => value.asEditable),
        approvedPatches.map(value => value),
        approvedPatchesComplianceLevel.map(value => value),
        approvedPatchesEnableNonSecurity.map(value => value),
        rejectedPatches.map(value => value),
        rejectedPatchesAction.map(value => value),
        description.map(value => value),
        sources.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        replace.map(value => value)
      )
    def baselineId: BaselineId
    def name: Optional[BaselineName]
    def globalFilters: Optional[zio.aws.ssm.model.PatchFilterGroup.ReadOnly]
    def approvalRules: Optional[zio.aws.ssm.model.PatchRuleGroup.ReadOnly]
    def approvedPatches: Optional[List[PatchId]]
    def approvedPatchesComplianceLevel
        : Optional[zio.aws.ssm.model.PatchComplianceLevel]
    def approvedPatchesEnableNonSecurity: Optional[Boolean]
    def rejectedPatches: Optional[List[PatchId]]
    def rejectedPatchesAction: Optional[zio.aws.ssm.model.PatchAction]
    def description: Optional[BaselineDescription]
    def sources: Optional[List[zio.aws.ssm.model.PatchSource.ReadOnly]]
    def replace: Optional[Boolean]
    def getBaselineId: ZIO[Any, Nothing, BaselineId] = ZIO.succeed(baselineId)
    def getName: ZIO[Any, AwsError, BaselineName] =
      AwsError.unwrapOptionField("name", name)
    def getGlobalFilters
        : ZIO[Any, AwsError, zio.aws.ssm.model.PatchFilterGroup.ReadOnly] =
      AwsError.unwrapOptionField("globalFilters", globalFilters)
    def getApprovalRules
        : ZIO[Any, AwsError, zio.aws.ssm.model.PatchRuleGroup.ReadOnly] =
      AwsError.unwrapOptionField("approvalRules", approvalRules)
    def getApprovedPatches: ZIO[Any, AwsError, List[PatchId]] =
      AwsError.unwrapOptionField("approvedPatches", approvedPatches)
    def getApprovedPatchesComplianceLevel
        : ZIO[Any, AwsError, zio.aws.ssm.model.PatchComplianceLevel] =
      AwsError.unwrapOptionField(
        "approvedPatchesComplianceLevel",
        approvedPatchesComplianceLevel
      )
    def getApprovedPatchesEnableNonSecurity: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField(
        "approvedPatchesEnableNonSecurity",
        approvedPatchesEnableNonSecurity
      )
    def getRejectedPatches: ZIO[Any, AwsError, List[PatchId]] =
      AwsError.unwrapOptionField("rejectedPatches", rejectedPatches)
    def getRejectedPatchesAction
        : ZIO[Any, AwsError, zio.aws.ssm.model.PatchAction] =
      AwsError.unwrapOptionField("rejectedPatchesAction", rejectedPatchesAction)
    def getDescription: ZIO[Any, AwsError, BaselineDescription] =
      AwsError.unwrapOptionField("description", description)
    def getSources
        : ZIO[Any, AwsError, List[zio.aws.ssm.model.PatchSource.ReadOnly]] =
      AwsError.unwrapOptionField("sources", sources)
    def getReplace: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("replace", replace)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ssm.model.UpdatePatchBaselineRequest
  ) extends zio.aws.ssm.model.UpdatePatchBaselineRequest.ReadOnly {
    override val baselineId: BaselineId =
      zio.aws.ssm.model.primitives.BaselineId(impl.baselineId())
    override val name: Optional[BaselineName] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => zio.aws.ssm.model.primitives.BaselineName(value))
    override val globalFilters
        : Optional[zio.aws.ssm.model.PatchFilterGroup.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.globalFilters())
        .map(value => zio.aws.ssm.model.PatchFilterGroup.wrap(value))
    override val approvalRules
        : Optional[zio.aws.ssm.model.PatchRuleGroup.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.approvalRules())
        .map(value => zio.aws.ssm.model.PatchRuleGroup.wrap(value))
    override val approvedPatches: Optional[List[PatchId]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.approvedPatches())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ssm.model.primitives.PatchId(item)
          }.toList
        )
    override val approvedPatchesComplianceLevel
        : Optional[zio.aws.ssm.model.PatchComplianceLevel] =
      zio.aws.core.internal
        .optionalFromNullable(impl.approvedPatchesComplianceLevel())
        .map(value => zio.aws.ssm.model.PatchComplianceLevel.wrap(value))
    override val approvedPatchesEnableNonSecurity: Optional[Boolean] =
      zio.aws.core.internal
        .optionalFromNullable(impl.approvedPatchesEnableNonSecurity())
        .map(value => value: Boolean)
    override val rejectedPatches: Optional[List[PatchId]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.rejectedPatches())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ssm.model.primitives.PatchId(item)
          }.toList
        )
    override val rejectedPatchesAction
        : Optional[zio.aws.ssm.model.PatchAction] = zio.aws.core.internal
      .optionalFromNullable(impl.rejectedPatchesAction())
      .map(value => zio.aws.ssm.model.PatchAction.wrap(value))
    override val description: Optional[BaselineDescription] =
      zio.aws.core.internal
        .optionalFromNullable(impl.description())
        .map(value => zio.aws.ssm.model.primitives.BaselineDescription(value))
    override val sources
        : Optional[List[zio.aws.ssm.model.PatchSource.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.sources())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ssm.model.PatchSource.wrap(item)
          }.toList
        )
    override val replace: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.replace())
      .map(value => value: Boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ssm.model.UpdatePatchBaselineRequest
  ): zio.aws.ssm.model.UpdatePatchBaselineRequest.ReadOnly = new Wrapper(impl)
}
