package zio.aws.ssmcontacts
import zio.aws.ssmcontacts.model.GetContactPolicyResponse.ReadOnly
import zio.aws.core.config.AwsConfig
import software.amazon.awssdk.services.ssmcontacts.model.{
  CreateContactResponse,
  CreateContactChannelRequest,
  GetContactChannelRequest,
  ListContactChannelsRequest,
  CreateContactRequest,
  ListContactsResponse,
  ListPageReceiptsResponse,
  DeleteContactRequest,
  StopEngagementRequest,
  AcceptPageResponse,
  CreateContactChannelResponse,
  StartEngagementRequest,
  DeactivateContactChannelRequest,
  GetContactResponse,
  PutContactPolicyResponse,
  UpdateContactChannelResponse,
  GetContactRequest,
  UpdateContactResponse,
  DeactivateContactChannelResponse,
  ListTagsForResourceRequest,
  ActivateContactChannelResponse,
  StartEngagementResponse,
  PutContactPolicyRequest,
  UpdateContactChannelRequest,
  DescribeEngagementRequest,
  DeleteContactChannelResponse,
  ListTagsForResourceResponse,
  Page,
  UntagResourceResponse,
  Engagement,
  ListPagesByContactResponse,
  GetContactChannelResponse,
  ListEngagementsRequest,
  GetContactPolicyRequest,
  DescribeEngagementResponse,
  ActivateContactChannelRequest,
  DeleteContactChannelRequest,
  GetContactPolicyResponse,
  StopEngagementResponse,
  AcceptPageRequest,
  ListPageReceiptsRequest,
  Contact,
  ListPagesByContactRequest,
  UntagResourceRequest,
  ListContactsRequest,
  SendActivationCodeResponse,
  ListPagesByEngagementRequest,
  ListPagesByEngagementResponse,
  ContactChannel,
  DescribePageRequest,
  DescribePageResponse,
  ListEngagementsResponse,
  TagResourceResponse,
  UpdateContactRequest,
  DeleteContactResponse,
  Receipt,
  TagResourceRequest,
  SendActivationCodeRequest,
  ListContactChannelsResponse
}
import zio.aws.core.{AwsServiceBase, AwsError}
import software.amazon.awssdk.services.ssmcontacts.{
  SsmContactsAsyncClientBuilder,
  SsmContactsAsyncClient
}
import zio.aws.core.aspects.{AwsCallAspect, AspectSupport}
import zio.{ZEnvironment, IO, ZIO, ZLayer, Scope}
import zio.stream.ZStream
import scala.jdk.CollectionConverters._
trait SsmContacts extends AspectSupport[SsmContacts] {
  val api: SsmContactsAsyncClient
  def updateContact(
      request: zio.aws.ssmcontacts.model.UpdateContactRequest
  ): IO[AwsError, zio.aws.ssmcontacts.model.UpdateContactResponse.ReadOnly]
  def getContactPolicy(
      request: zio.aws.ssmcontacts.model.GetContactPolicyRequest
  ): IO[AwsError, ReadOnly]
  def activateContactChannel(
      request: zio.aws.ssmcontacts.model.ActivateContactChannelRequest
  ): IO[
    AwsError,
    zio.aws.ssmcontacts.model.ActivateContactChannelResponse.ReadOnly
  ]
  def listPagesByContact(
      request: zio.aws.ssmcontacts.model.ListPagesByContactRequest
  ): ZStream[Any, AwsError, zio.aws.ssmcontacts.model.Page.ReadOnly]
  def listPagesByContactPaginated(
      request: zio.aws.ssmcontacts.model.ListPagesByContactRequest
  ): IO[AwsError, zio.aws.ssmcontacts.model.ListPagesByContactResponse.ReadOnly]
  def deleteContactChannel(
      request: zio.aws.ssmcontacts.model.DeleteContactChannelRequest
  ): IO[
    AwsError,
    zio.aws.ssmcontacts.model.DeleteContactChannelResponse.ReadOnly
  ]
  def createContactChannel(
      request: zio.aws.ssmcontacts.model.CreateContactChannelRequest
  ): IO[
    AwsError,
    zio.aws.ssmcontacts.model.CreateContactChannelResponse.ReadOnly
  ]
  def deleteContact(
      request: zio.aws.ssmcontacts.model.DeleteContactRequest
  ): IO[AwsError, zio.aws.ssmcontacts.model.DeleteContactResponse.ReadOnly]
  def createContact(
      request: zio.aws.ssmcontacts.model.CreateContactRequest
  ): IO[AwsError, zio.aws.ssmcontacts.model.CreateContactResponse.ReadOnly]
  def listEngagements(
      request: zio.aws.ssmcontacts.model.ListEngagementsRequest
  ): ZStream[Any, AwsError, zio.aws.ssmcontacts.model.Engagement.ReadOnly]
  def listEngagementsPaginated(
      request: zio.aws.ssmcontacts.model.ListEngagementsRequest
  ): IO[AwsError, zio.aws.ssmcontacts.model.ListEngagementsResponse.ReadOnly]
  def listPagesByEngagement(
      request: zio.aws.ssmcontacts.model.ListPagesByEngagementRequest
  ): ZStream[Any, AwsError, zio.aws.ssmcontacts.model.Page.ReadOnly]
  def listPagesByEngagementPaginated(
      request: zio.aws.ssmcontacts.model.ListPagesByEngagementRequest
  ): IO[
    AwsError,
    zio.aws.ssmcontacts.model.ListPagesByEngagementResponse.ReadOnly
  ]
  def deactivateContactChannel(
      request: zio.aws.ssmcontacts.model.DeactivateContactChannelRequest
  ): IO[
    AwsError,
    zio.aws.ssmcontacts.model.DeactivateContactChannelResponse.ReadOnly
  ]
  def describePage(
      request: zio.aws.ssmcontacts.model.DescribePageRequest
  ): IO[AwsError, zio.aws.ssmcontacts.model.DescribePageResponse.ReadOnly]
  def sendActivationCode(
      request: zio.aws.ssmcontacts.model.SendActivationCodeRequest
  ): IO[AwsError, zio.aws.ssmcontacts.model.SendActivationCodeResponse.ReadOnly]
  def startEngagement(
      request: zio.aws.ssmcontacts.model.StartEngagementRequest
  ): IO[AwsError, zio.aws.ssmcontacts.model.StartEngagementResponse.ReadOnly]
  def acceptPage(
      request: zio.aws.ssmcontacts.model.AcceptPageRequest
  ): IO[AwsError, zio.aws.ssmcontacts.model.AcceptPageResponse.ReadOnly]
  def getContactChannel(
      request: zio.aws.ssmcontacts.model.GetContactChannelRequest
  ): IO[AwsError, zio.aws.ssmcontacts.model.GetContactChannelResponse.ReadOnly]
  def untagResource(
      request: zio.aws.ssmcontacts.model.UntagResourceRequest
  ): IO[AwsError, zio.aws.ssmcontacts.model.UntagResourceResponse.ReadOnly]
  def listPageReceipts(
      request: zio.aws.ssmcontacts.model.ListPageReceiptsRequest
  ): ZStream[Any, AwsError, zio.aws.ssmcontacts.model.Receipt.ReadOnly]
  def listPageReceiptsPaginated(
      request: zio.aws.ssmcontacts.model.ListPageReceiptsRequest
  ): IO[AwsError, zio.aws.ssmcontacts.model.ListPageReceiptsResponse.ReadOnly]
  def listTagsForResource(
      request: zio.aws.ssmcontacts.model.ListTagsForResourceRequest
  ): IO[
    AwsError,
    zio.aws.ssmcontacts.model.ListTagsForResourceResponse.ReadOnly
  ]
  def tagResource(
      request: zio.aws.ssmcontacts.model.TagResourceRequest
  ): IO[AwsError, zio.aws.ssmcontacts.model.TagResourceResponse.ReadOnly]
  def describeEngagement(
      request: zio.aws.ssmcontacts.model.DescribeEngagementRequest
  ): IO[AwsError, zio.aws.ssmcontacts.model.DescribeEngagementResponse.ReadOnly]
  def getContact(
      request: zio.aws.ssmcontacts.model.GetContactRequest
  ): IO[AwsError, zio.aws.ssmcontacts.model.GetContactResponse.ReadOnly]
  def listContacts(
      request: zio.aws.ssmcontacts.model.ListContactsRequest
  ): ZStream[Any, AwsError, zio.aws.ssmcontacts.model.Contact.ReadOnly]
  def listContactsPaginated(
      request: zio.aws.ssmcontacts.model.ListContactsRequest
  ): IO[AwsError, zio.aws.ssmcontacts.model.ListContactsResponse.ReadOnly]
  def putContactPolicy(
      request: zio.aws.ssmcontacts.model.PutContactPolicyRequest
  ): IO[AwsError, zio.aws.ssmcontacts.model.PutContactPolicyResponse.ReadOnly]
  def updateContactChannel(
      request: zio.aws.ssmcontacts.model.UpdateContactChannelRequest
  ): IO[
    AwsError,
    zio.aws.ssmcontacts.model.UpdateContactChannelResponse.ReadOnly
  ]
  def listContactChannels(
      request: zio.aws.ssmcontacts.model.ListContactChannelsRequest
  ): ZStream[Any, AwsError, zio.aws.ssmcontacts.model.ContactChannel.ReadOnly]
  def listContactChannelsPaginated(
      request: zio.aws.ssmcontacts.model.ListContactChannelsRequest
  ): IO[
    AwsError,
    zio.aws.ssmcontacts.model.ListContactChannelsResponse.ReadOnly
  ]
  def stopEngagement(
      request: zio.aws.ssmcontacts.model.StopEngagementRequest
  ): IO[AwsError, zio.aws.ssmcontacts.model.StopEngagementResponse.ReadOnly]
}
object SsmContacts {
  val live: ZLayer[AwsConfig, java.lang.Throwable, SsmContacts] = customized(
    identity
  )
  def customized(
      customization: SsmContactsAsyncClientBuilder => SsmContactsAsyncClientBuilder
  ): ZLayer[AwsConfig, java.lang.Throwable, SsmContacts] =
    ZLayer.scoped(scoped(customization))
  def scoped(
      customization: SsmContactsAsyncClientBuilder => SsmContactsAsyncClientBuilder
  ): ZIO[AwsConfig with Scope, java.lang.Throwable, SsmContacts] = for (
    awsConfig <- ZIO.service[AwsConfig]; executor <- ZIO.executor;
    builder = SsmContactsAsyncClient
      .builder()
      .asyncConfiguration(
        software.amazon.awssdk.core.client.config.ClientAsyncConfiguration
          .builder()
          .advancedOption(
            software.amazon.awssdk.core.client.config.SdkAdvancedAsyncClientOption.FUTURE_COMPLETION_EXECUTOR,
            executor.asJava
          )
          .build()
      );
    b0 <- awsConfig
      .configure[SsmContactsAsyncClient, SsmContactsAsyncClientBuilder](
        builder
      );
    b1 <- awsConfig.configureHttpClient[
      SsmContactsAsyncClient,
      SsmContactsAsyncClientBuilder
    ](
      b0,
      zio.aws.core.httpclient.ServiceHttpCapabilities(supportsHttp2 = false)
    ); client <- ZIO.attempt(customization(b1).build())
  )
    yield new SsmContactsImpl(
      client,
      AwsCallAspect.identity,
      ZEnvironment.empty
    )
  private class SsmContactsImpl[R](
      override val api: SsmContactsAsyncClient,
      override val aspect: AwsCallAspect[R],
      r: ZEnvironment[R]
  ) extends SsmContacts
      with AwsServiceBase[R] {
    override val serviceName: String = "SsmContacts"
    override def withAspect[R1](
        newAspect: AwsCallAspect[R1],
        r: ZEnvironment[R1]
    ): SsmContactsImpl[R1] = new SsmContactsImpl(api, newAspect, r)
    def updateContact(
        request: zio.aws.ssmcontacts.model.UpdateContactRequest
    ): IO[AwsError, zio.aws.ssmcontacts.model.UpdateContactResponse.ReadOnly] =
      asyncRequestResponse[UpdateContactRequest, UpdateContactResponse](
        "updateContact",
        api.updateContact
      )(request.buildAwsValue())
        .map(zio.aws.ssmcontacts.model.UpdateContactResponse.wrap)
        .provideEnvironment(r)
    def getContactPolicy(
        request: zio.aws.ssmcontacts.model.GetContactPolicyRequest
    ): IO[AwsError, ReadOnly] =
      asyncRequestResponse[GetContactPolicyRequest, GetContactPolicyResponse](
        "getContactPolicy",
        api.getContactPolicy
      )(request.buildAwsValue())
        .map(zio.aws.ssmcontacts.model.GetContactPolicyResponse.wrap)
        .provideEnvironment(r)
    def activateContactChannel(
        request: zio.aws.ssmcontacts.model.ActivateContactChannelRequest
    ): IO[
      AwsError,
      zio.aws.ssmcontacts.model.ActivateContactChannelResponse.ReadOnly
    ] = asyncRequestResponse[
      ActivateContactChannelRequest,
      ActivateContactChannelResponse
    ]("activateContactChannel", api.activateContactChannel)(
      request.buildAwsValue()
    ).map(zio.aws.ssmcontacts.model.ActivateContactChannelResponse.wrap)
      .provideEnvironment(r)
    def listPagesByContact(
        request: zio.aws.ssmcontacts.model.ListPagesByContactRequest
    ): ZStream[Any, AwsError, zio.aws.ssmcontacts.model.Page.ReadOnly] =
      asyncSimplePaginatedRequest[
        ListPagesByContactRequest,
        ListPagesByContactResponse,
        Page
      ](
        "listPagesByContact",
        api.listPagesByContact,
        (r, token) => r.toBuilder().nextToken(token).build(),
        r => scala.Option(r.nextToken()),
        r => zio.Chunk.fromIterable(r.pages().asScala)
      )(request.buildAwsValue())
        .map(item => zio.aws.ssmcontacts.model.Page.wrap(item))
        .provideEnvironment(r)
    def listPagesByContactPaginated(
        request: zio.aws.ssmcontacts.model.ListPagesByContactRequest
    ): IO[
      AwsError,
      zio.aws.ssmcontacts.model.ListPagesByContactResponse.ReadOnly
    ] = asyncRequestResponse[
      ListPagesByContactRequest,
      ListPagesByContactResponse
    ]("listPagesByContact", api.listPagesByContact)(request.buildAwsValue())
      .map(zio.aws.ssmcontacts.model.ListPagesByContactResponse.wrap)
      .provideEnvironment(r)
    def deleteContactChannel(
        request: zio.aws.ssmcontacts.model.DeleteContactChannelRequest
    ): IO[
      AwsError,
      zio.aws.ssmcontacts.model.DeleteContactChannelResponse.ReadOnly
    ] = asyncRequestResponse[
      DeleteContactChannelRequest,
      DeleteContactChannelResponse
    ]("deleteContactChannel", api.deleteContactChannel)(request.buildAwsValue())
      .map(zio.aws.ssmcontacts.model.DeleteContactChannelResponse.wrap)
      .provideEnvironment(r)
    def createContactChannel(
        request: zio.aws.ssmcontacts.model.CreateContactChannelRequest
    ): IO[
      AwsError,
      zio.aws.ssmcontacts.model.CreateContactChannelResponse.ReadOnly
    ] = asyncRequestResponse[
      CreateContactChannelRequest,
      CreateContactChannelResponse
    ]("createContactChannel", api.createContactChannel)(request.buildAwsValue())
      .map(zio.aws.ssmcontacts.model.CreateContactChannelResponse.wrap)
      .provideEnvironment(r)
    def deleteContact(
        request: zio.aws.ssmcontacts.model.DeleteContactRequest
    ): IO[AwsError, zio.aws.ssmcontacts.model.DeleteContactResponse.ReadOnly] =
      asyncRequestResponse[DeleteContactRequest, DeleteContactResponse](
        "deleteContact",
        api.deleteContact
      )(request.buildAwsValue())
        .map(zio.aws.ssmcontacts.model.DeleteContactResponse.wrap)
        .provideEnvironment(r)
    def createContact(
        request: zio.aws.ssmcontacts.model.CreateContactRequest
    ): IO[AwsError, zio.aws.ssmcontacts.model.CreateContactResponse.ReadOnly] =
      asyncRequestResponse[CreateContactRequest, CreateContactResponse](
        "createContact",
        api.createContact
      )(request.buildAwsValue())
        .map(zio.aws.ssmcontacts.model.CreateContactResponse.wrap)
        .provideEnvironment(r)
    def listEngagements(
        request: zio.aws.ssmcontacts.model.ListEngagementsRequest
    ): ZStream[Any, AwsError, zio.aws.ssmcontacts.model.Engagement.ReadOnly] =
      asyncSimplePaginatedRequest[
        ListEngagementsRequest,
        ListEngagementsResponse,
        Engagement
      ](
        "listEngagements",
        api.listEngagements,
        (r, token) => r.toBuilder().nextToken(token).build(),
        r => scala.Option(r.nextToken()),
        r => zio.Chunk.fromIterable(r.engagements().asScala)
      )(request.buildAwsValue())
        .map(item => zio.aws.ssmcontacts.model.Engagement.wrap(item))
        .provideEnvironment(r)
    def listEngagementsPaginated(
        request: zio.aws.ssmcontacts.model.ListEngagementsRequest
    ): IO[
      AwsError,
      zio.aws.ssmcontacts.model.ListEngagementsResponse.ReadOnly
    ] = asyncRequestResponse[ListEngagementsRequest, ListEngagementsResponse](
      "listEngagements",
      api.listEngagements
    )(request.buildAwsValue())
      .map(zio.aws.ssmcontacts.model.ListEngagementsResponse.wrap)
      .provideEnvironment(r)
    def listPagesByEngagement(
        request: zio.aws.ssmcontacts.model.ListPagesByEngagementRequest
    ): ZStream[Any, AwsError, zio.aws.ssmcontacts.model.Page.ReadOnly] =
      asyncSimplePaginatedRequest[
        ListPagesByEngagementRequest,
        ListPagesByEngagementResponse,
        Page
      ](
        "listPagesByEngagement",
        api.listPagesByEngagement,
        (r, token) => r.toBuilder().nextToken(token).build(),
        r => scala.Option(r.nextToken()),
        r => zio.Chunk.fromIterable(r.pages().asScala)
      )(request.buildAwsValue())
        .map(item => zio.aws.ssmcontacts.model.Page.wrap(item))
        .provideEnvironment(r)
    def listPagesByEngagementPaginated(
        request: zio.aws.ssmcontacts.model.ListPagesByEngagementRequest
    ): IO[
      AwsError,
      zio.aws.ssmcontacts.model.ListPagesByEngagementResponse.ReadOnly
    ] = asyncRequestResponse[
      ListPagesByEngagementRequest,
      ListPagesByEngagementResponse
    ]("listPagesByEngagement", api.listPagesByEngagement)(
      request.buildAwsValue()
    ).map(zio.aws.ssmcontacts.model.ListPagesByEngagementResponse.wrap)
      .provideEnvironment(r)
    def deactivateContactChannel(
        request: zio.aws.ssmcontacts.model.DeactivateContactChannelRequest
    ): IO[
      AwsError,
      zio.aws.ssmcontacts.model.DeactivateContactChannelResponse.ReadOnly
    ] = asyncRequestResponse[
      DeactivateContactChannelRequest,
      DeactivateContactChannelResponse
    ]("deactivateContactChannel", api.deactivateContactChannel)(
      request.buildAwsValue()
    ).map(zio.aws.ssmcontacts.model.DeactivateContactChannelResponse.wrap)
      .provideEnvironment(r)
    def describePage(
        request: zio.aws.ssmcontacts.model.DescribePageRequest
    ): IO[AwsError, zio.aws.ssmcontacts.model.DescribePageResponse.ReadOnly] =
      asyncRequestResponse[DescribePageRequest, DescribePageResponse](
        "describePage",
        api.describePage
      )(request.buildAwsValue())
        .map(zio.aws.ssmcontacts.model.DescribePageResponse.wrap)
        .provideEnvironment(r)
    def sendActivationCode(
        request: zio.aws.ssmcontacts.model.SendActivationCodeRequest
    ): IO[
      AwsError,
      zio.aws.ssmcontacts.model.SendActivationCodeResponse.ReadOnly
    ] = asyncRequestResponse[
      SendActivationCodeRequest,
      SendActivationCodeResponse
    ]("sendActivationCode", api.sendActivationCode)(request.buildAwsValue())
      .map(zio.aws.ssmcontacts.model.SendActivationCodeResponse.wrap)
      .provideEnvironment(r)
    def startEngagement(
        request: zio.aws.ssmcontacts.model.StartEngagementRequest
    ): IO[
      AwsError,
      zio.aws.ssmcontacts.model.StartEngagementResponse.ReadOnly
    ] = asyncRequestResponse[StartEngagementRequest, StartEngagementResponse](
      "startEngagement",
      api.startEngagement
    )(request.buildAwsValue())
      .map(zio.aws.ssmcontacts.model.StartEngagementResponse.wrap)
      .provideEnvironment(r)
    def acceptPage(
        request: zio.aws.ssmcontacts.model.AcceptPageRequest
    ): IO[AwsError, zio.aws.ssmcontacts.model.AcceptPageResponse.ReadOnly] =
      asyncRequestResponse[AcceptPageRequest, AcceptPageResponse](
        "acceptPage",
        api.acceptPage
      )(request.buildAwsValue())
        .map(zio.aws.ssmcontacts.model.AcceptPageResponse.wrap)
        .provideEnvironment(r)
    def getContactChannel(
        request: zio.aws.ssmcontacts.model.GetContactChannelRequest
    ): IO[
      AwsError,
      zio.aws.ssmcontacts.model.GetContactChannelResponse.ReadOnly
    ] =
      asyncRequestResponse[GetContactChannelRequest, GetContactChannelResponse](
        "getContactChannel",
        api.getContactChannel
      )(request.buildAwsValue())
        .map(zio.aws.ssmcontacts.model.GetContactChannelResponse.wrap)
        .provideEnvironment(r)
    def untagResource(
        request: zio.aws.ssmcontacts.model.UntagResourceRequest
    ): IO[AwsError, zio.aws.ssmcontacts.model.UntagResourceResponse.ReadOnly] =
      asyncRequestResponse[UntagResourceRequest, UntagResourceResponse](
        "untagResource",
        api.untagResource
      )(request.buildAwsValue())
        .map(zio.aws.ssmcontacts.model.UntagResourceResponse.wrap)
        .provideEnvironment(r)
    def listPageReceipts(
        request: zio.aws.ssmcontacts.model.ListPageReceiptsRequest
    ): ZStream[Any, AwsError, zio.aws.ssmcontacts.model.Receipt.ReadOnly] =
      asyncSimplePaginatedRequest[
        ListPageReceiptsRequest,
        ListPageReceiptsResponse,
        Receipt
      ](
        "listPageReceipts",
        api.listPageReceipts,
        (r, token) => r.toBuilder().nextToken(token).build(),
        r => scala.Option(r.nextToken()),
        r => zio.Chunk.fromIterable(r.receipts().asScala)
      )(request.buildAwsValue())
        .map(item => zio.aws.ssmcontacts.model.Receipt.wrap(item))
        .provideEnvironment(r)
    def listPageReceiptsPaginated(
        request: zio.aws.ssmcontacts.model.ListPageReceiptsRequest
    ): IO[
      AwsError,
      zio.aws.ssmcontacts.model.ListPageReceiptsResponse.ReadOnly
    ] = asyncRequestResponse[ListPageReceiptsRequest, ListPageReceiptsResponse](
      "listPageReceipts",
      api.listPageReceipts
    )(request.buildAwsValue())
      .map(zio.aws.ssmcontacts.model.ListPageReceiptsResponse.wrap)
      .provideEnvironment(r)
    def listTagsForResource(
        request: zio.aws.ssmcontacts.model.ListTagsForResourceRequest
    ): IO[
      AwsError,
      zio.aws.ssmcontacts.model.ListTagsForResourceResponse.ReadOnly
    ] = asyncRequestResponse[
      ListTagsForResourceRequest,
      ListTagsForResourceResponse
    ]("listTagsForResource", api.listTagsForResource)(request.buildAwsValue())
      .map(zio.aws.ssmcontacts.model.ListTagsForResourceResponse.wrap)
      .provideEnvironment(r)
    def tagResource(
        request: zio.aws.ssmcontacts.model.TagResourceRequest
    ): IO[AwsError, zio.aws.ssmcontacts.model.TagResourceResponse.ReadOnly] =
      asyncRequestResponse[TagResourceRequest, TagResourceResponse](
        "tagResource",
        api.tagResource
      )(request.buildAwsValue())
        .map(zio.aws.ssmcontacts.model.TagResourceResponse.wrap)
        .provideEnvironment(r)
    def describeEngagement(
        request: zio.aws.ssmcontacts.model.DescribeEngagementRequest
    ): IO[
      AwsError,
      zio.aws.ssmcontacts.model.DescribeEngagementResponse.ReadOnly
    ] = asyncRequestResponse[
      DescribeEngagementRequest,
      DescribeEngagementResponse
    ]("describeEngagement", api.describeEngagement)(request.buildAwsValue())
      .map(zio.aws.ssmcontacts.model.DescribeEngagementResponse.wrap)
      .provideEnvironment(r)
    def getContact(
        request: zio.aws.ssmcontacts.model.GetContactRequest
    ): IO[AwsError, zio.aws.ssmcontacts.model.GetContactResponse.ReadOnly] =
      asyncRequestResponse[GetContactRequest, GetContactResponse](
        "getContact",
        api.getContact
      )(request.buildAwsValue())
        .map(zio.aws.ssmcontacts.model.GetContactResponse.wrap)
        .provideEnvironment(r)
    def listContacts(
        request: zio.aws.ssmcontacts.model.ListContactsRequest
    ): ZStream[Any, AwsError, zio.aws.ssmcontacts.model.Contact.ReadOnly] =
      asyncSimplePaginatedRequest[
        ListContactsRequest,
        ListContactsResponse,
        Contact
      ](
        "listContacts",
        api.listContacts,
        (r, token) => r.toBuilder().nextToken(token).build(),
        r => scala.Option(r.nextToken()),
        r => zio.Chunk.fromIterable(r.contacts().asScala)
      )(request.buildAwsValue())
        .map(item => zio.aws.ssmcontacts.model.Contact.wrap(item))
        .provideEnvironment(r)
    def listContactsPaginated(
        request: zio.aws.ssmcontacts.model.ListContactsRequest
    ): IO[AwsError, zio.aws.ssmcontacts.model.ListContactsResponse.ReadOnly] =
      asyncRequestResponse[ListContactsRequest, ListContactsResponse](
        "listContacts",
        api.listContacts
      )(request.buildAwsValue())
        .map(zio.aws.ssmcontacts.model.ListContactsResponse.wrap)
        .provideEnvironment(r)
    def putContactPolicy(
        request: zio.aws.ssmcontacts.model.PutContactPolicyRequest
    ): IO[
      AwsError,
      zio.aws.ssmcontacts.model.PutContactPolicyResponse.ReadOnly
    ] = asyncRequestResponse[PutContactPolicyRequest, PutContactPolicyResponse](
      "putContactPolicy",
      api.putContactPolicy
    )(request.buildAwsValue())
      .map(zio.aws.ssmcontacts.model.PutContactPolicyResponse.wrap)
      .provideEnvironment(r)
    def updateContactChannel(
        request: zio.aws.ssmcontacts.model.UpdateContactChannelRequest
    ): IO[
      AwsError,
      zio.aws.ssmcontacts.model.UpdateContactChannelResponse.ReadOnly
    ] = asyncRequestResponse[
      UpdateContactChannelRequest,
      UpdateContactChannelResponse
    ]("updateContactChannel", api.updateContactChannel)(request.buildAwsValue())
      .map(zio.aws.ssmcontacts.model.UpdateContactChannelResponse.wrap)
      .provideEnvironment(r)
    def listContactChannels(
        request: zio.aws.ssmcontacts.model.ListContactChannelsRequest
    ): ZStream[
      Any,
      AwsError,
      zio.aws.ssmcontacts.model.ContactChannel.ReadOnly
    ] = asyncSimplePaginatedRequest[
      ListContactChannelsRequest,
      ListContactChannelsResponse,
      ContactChannel
    ](
      "listContactChannels",
      api.listContactChannels,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.contactChannels().asScala)
    )(request.buildAwsValue())
      .map(item => zio.aws.ssmcontacts.model.ContactChannel.wrap(item))
      .provideEnvironment(r)
    def listContactChannelsPaginated(
        request: zio.aws.ssmcontacts.model.ListContactChannelsRequest
    ): IO[
      AwsError,
      zio.aws.ssmcontacts.model.ListContactChannelsResponse.ReadOnly
    ] = asyncRequestResponse[
      ListContactChannelsRequest,
      ListContactChannelsResponse
    ]("listContactChannels", api.listContactChannels)(request.buildAwsValue())
      .map(zio.aws.ssmcontacts.model.ListContactChannelsResponse.wrap)
      .provideEnvironment(r)
    def stopEngagement(
        request: zio.aws.ssmcontacts.model.StopEngagementRequest
    ): IO[AwsError, zio.aws.ssmcontacts.model.StopEngagementResponse.ReadOnly] =
      asyncRequestResponse[StopEngagementRequest, StopEngagementResponse](
        "stopEngagement",
        api.stopEngagement
      )(request.buildAwsValue())
        .map(zio.aws.ssmcontacts.model.StopEngagementResponse.wrap)
        .provideEnvironment(r)
  }
  def updateContact(
      request: zio.aws.ssmcontacts.model.UpdateContactRequest
  ): ZIO[
    zio.aws.ssmcontacts.SsmContacts,
    AwsError,
    zio.aws.ssmcontacts.model.UpdateContactResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateContact(request))
  def getContactPolicy(
      request: zio.aws.ssmcontacts.model.GetContactPolicyRequest
  ): ZIO[zio.aws.ssmcontacts.SsmContacts, AwsError, ReadOnly] =
    ZIO.serviceWithZIO(_.getContactPolicy(request))
  def activateContactChannel(
      request: zio.aws.ssmcontacts.model.ActivateContactChannelRequest
  ): ZIO[
    zio.aws.ssmcontacts.SsmContacts,
    AwsError,
    zio.aws.ssmcontacts.model.ActivateContactChannelResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.activateContactChannel(request))
  def listPagesByContact(
      request: zio.aws.ssmcontacts.model.ListPagesByContactRequest
  ): ZStream[
    zio.aws.ssmcontacts.SsmContacts,
    AwsError,
    zio.aws.ssmcontacts.model.Page.ReadOnly
  ] = ZStream.serviceWithStream(_.listPagesByContact(request))
  def listPagesByContactPaginated(
      request: zio.aws.ssmcontacts.model.ListPagesByContactRequest
  ): ZIO[
    zio.aws.ssmcontacts.SsmContacts,
    AwsError,
    zio.aws.ssmcontacts.model.ListPagesByContactResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listPagesByContactPaginated(request))
  def deleteContactChannel(
      request: zio.aws.ssmcontacts.model.DeleteContactChannelRequest
  ): ZIO[
    zio.aws.ssmcontacts.SsmContacts,
    AwsError,
    zio.aws.ssmcontacts.model.DeleteContactChannelResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteContactChannel(request))
  def createContactChannel(
      request: zio.aws.ssmcontacts.model.CreateContactChannelRequest
  ): ZIO[
    zio.aws.ssmcontacts.SsmContacts,
    AwsError,
    zio.aws.ssmcontacts.model.CreateContactChannelResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createContactChannel(request))
  def deleteContact(
      request: zio.aws.ssmcontacts.model.DeleteContactRequest
  ): ZIO[
    zio.aws.ssmcontacts.SsmContacts,
    AwsError,
    zio.aws.ssmcontacts.model.DeleteContactResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteContact(request))
  def createContact(
      request: zio.aws.ssmcontacts.model.CreateContactRequest
  ): ZIO[
    zio.aws.ssmcontacts.SsmContacts,
    AwsError,
    zio.aws.ssmcontacts.model.CreateContactResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createContact(request))
  def listEngagements(
      request: zio.aws.ssmcontacts.model.ListEngagementsRequest
  ): ZStream[
    zio.aws.ssmcontacts.SsmContacts,
    AwsError,
    zio.aws.ssmcontacts.model.Engagement.ReadOnly
  ] = ZStream.serviceWithStream(_.listEngagements(request))
  def listEngagementsPaginated(
      request: zio.aws.ssmcontacts.model.ListEngagementsRequest
  ): ZIO[
    zio.aws.ssmcontacts.SsmContacts,
    AwsError,
    zio.aws.ssmcontacts.model.ListEngagementsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listEngagementsPaginated(request))
  def listPagesByEngagement(
      request: zio.aws.ssmcontacts.model.ListPagesByEngagementRequest
  ): ZStream[
    zio.aws.ssmcontacts.SsmContacts,
    AwsError,
    zio.aws.ssmcontacts.model.Page.ReadOnly
  ] = ZStream.serviceWithStream(_.listPagesByEngagement(request))
  def listPagesByEngagementPaginated(
      request: zio.aws.ssmcontacts.model.ListPagesByEngagementRequest
  ): ZIO[
    zio.aws.ssmcontacts.SsmContacts,
    AwsError,
    zio.aws.ssmcontacts.model.ListPagesByEngagementResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listPagesByEngagementPaginated(request))
  def deactivateContactChannel(
      request: zio.aws.ssmcontacts.model.DeactivateContactChannelRequest
  ): ZIO[
    zio.aws.ssmcontacts.SsmContacts,
    AwsError,
    zio.aws.ssmcontacts.model.DeactivateContactChannelResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deactivateContactChannel(request))
  def describePage(request: zio.aws.ssmcontacts.model.DescribePageRequest): ZIO[
    zio.aws.ssmcontacts.SsmContacts,
    AwsError,
    zio.aws.ssmcontacts.model.DescribePageResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describePage(request))
  def sendActivationCode(
      request: zio.aws.ssmcontacts.model.SendActivationCodeRequest
  ): ZIO[
    zio.aws.ssmcontacts.SsmContacts,
    AwsError,
    zio.aws.ssmcontacts.model.SendActivationCodeResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.sendActivationCode(request))
  def startEngagement(
      request: zio.aws.ssmcontacts.model.StartEngagementRequest
  ): ZIO[
    zio.aws.ssmcontacts.SsmContacts,
    AwsError,
    zio.aws.ssmcontacts.model.StartEngagementResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.startEngagement(request))
  def acceptPage(request: zio.aws.ssmcontacts.model.AcceptPageRequest): ZIO[
    zio.aws.ssmcontacts.SsmContacts,
    AwsError,
    zio.aws.ssmcontacts.model.AcceptPageResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.acceptPage(request))
  def getContactChannel(
      request: zio.aws.ssmcontacts.model.GetContactChannelRequest
  ): ZIO[
    zio.aws.ssmcontacts.SsmContacts,
    AwsError,
    zio.aws.ssmcontacts.model.GetContactChannelResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getContactChannel(request))
  def untagResource(
      request: zio.aws.ssmcontacts.model.UntagResourceRequest
  ): ZIO[
    zio.aws.ssmcontacts.SsmContacts,
    AwsError,
    zio.aws.ssmcontacts.model.UntagResourceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.untagResource(request))
  def listPageReceipts(
      request: zio.aws.ssmcontacts.model.ListPageReceiptsRequest
  ): ZStream[
    zio.aws.ssmcontacts.SsmContacts,
    AwsError,
    zio.aws.ssmcontacts.model.Receipt.ReadOnly
  ] = ZStream.serviceWithStream(_.listPageReceipts(request))
  def listPageReceiptsPaginated(
      request: zio.aws.ssmcontacts.model.ListPageReceiptsRequest
  ): ZIO[
    zio.aws.ssmcontacts.SsmContacts,
    AwsError,
    zio.aws.ssmcontacts.model.ListPageReceiptsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listPageReceiptsPaginated(request))
  def listTagsForResource(
      request: zio.aws.ssmcontacts.model.ListTagsForResourceRequest
  ): ZIO[
    zio.aws.ssmcontacts.SsmContacts,
    AwsError,
    zio.aws.ssmcontacts.model.ListTagsForResourceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listTagsForResource(request))
  def tagResource(request: zio.aws.ssmcontacts.model.TagResourceRequest): ZIO[
    zio.aws.ssmcontacts.SsmContacts,
    AwsError,
    zio.aws.ssmcontacts.model.TagResourceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.tagResource(request))
  def describeEngagement(
      request: zio.aws.ssmcontacts.model.DescribeEngagementRequest
  ): ZIO[
    zio.aws.ssmcontacts.SsmContacts,
    AwsError,
    zio.aws.ssmcontacts.model.DescribeEngagementResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeEngagement(request))
  def getContact(request: zio.aws.ssmcontacts.model.GetContactRequest): ZIO[
    zio.aws.ssmcontacts.SsmContacts,
    AwsError,
    zio.aws.ssmcontacts.model.GetContactResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getContact(request))
  def listContacts(
      request: zio.aws.ssmcontacts.model.ListContactsRequest
  ): ZStream[
    zio.aws.ssmcontacts.SsmContacts,
    AwsError,
    zio.aws.ssmcontacts.model.Contact.ReadOnly
  ] = ZStream.serviceWithStream(_.listContacts(request))
  def listContactsPaginated(
      request: zio.aws.ssmcontacts.model.ListContactsRequest
  ): ZIO[
    zio.aws.ssmcontacts.SsmContacts,
    AwsError,
    zio.aws.ssmcontacts.model.ListContactsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listContactsPaginated(request))
  def putContactPolicy(
      request: zio.aws.ssmcontacts.model.PutContactPolicyRequest
  ): ZIO[
    zio.aws.ssmcontacts.SsmContacts,
    AwsError,
    zio.aws.ssmcontacts.model.PutContactPolicyResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.putContactPolicy(request))
  def updateContactChannel(
      request: zio.aws.ssmcontacts.model.UpdateContactChannelRequest
  ): ZIO[
    zio.aws.ssmcontacts.SsmContacts,
    AwsError,
    zio.aws.ssmcontacts.model.UpdateContactChannelResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateContactChannel(request))
  def listContactChannels(
      request: zio.aws.ssmcontacts.model.ListContactChannelsRequest
  ): ZStream[
    zio.aws.ssmcontacts.SsmContacts,
    AwsError,
    zio.aws.ssmcontacts.model.ContactChannel.ReadOnly
  ] = ZStream.serviceWithStream(_.listContactChannels(request))
  def listContactChannelsPaginated(
      request: zio.aws.ssmcontacts.model.ListContactChannelsRequest
  ): ZIO[
    zio.aws.ssmcontacts.SsmContacts,
    AwsError,
    zio.aws.ssmcontacts.model.ListContactChannelsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listContactChannelsPaginated(request))
  def stopEngagement(
      request: zio.aws.ssmcontacts.model.StopEngagementRequest
  ): ZIO[
    zio.aws.ssmcontacts.SsmContacts,
    AwsError,
    zio.aws.ssmcontacts.model.StopEngagementResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.stopEngagement(request))
}
