package zio.aws.ssmcontacts
import zio.aws.ssmcontacts.model.GetContactPolicyResponse.ReadOnly
import zio.mock.{Proxy, Mock}
import zio.aws.core.AwsError
import software.amazon.awssdk.services.ssmcontacts.SsmContactsAsyncClient
import zio.aws.core.aspects.AwsCallAspect
import zio.{IO, ZEnvironment, URLayer}
import zio.aws.ssmcontacts.model.{
  CreateContactChannelRequest,
  GetContactChannelRequest,
  ListContactChannelsRequest,
  CreateContactRequest,
  DeleteContactRequest,
  StopEngagementRequest,
  StartEngagementRequest,
  DeactivateContactChannelRequest,
  GetContactRequest,
  ListTagsForResourceRequest,
  PutContactPolicyRequest,
  UpdateContactChannelRequest,
  DescribeEngagementRequest,
  ListEngagementsRequest,
  GetContactPolicyRequest,
  ActivateContactChannelRequest,
  DeleteContactChannelRequest,
  AcceptPageRequest,
  ListPageReceiptsRequest,
  ListPagesByContactRequest,
  UntagResourceRequest,
  ListContactsRequest,
  ListPagesByEngagementRequest,
  DescribePageRequest,
  UpdateContactRequest,
  TagResourceRequest,
  SendActivationCodeRequest
}
import zio.stream.ZStream
object SsmContactsMock extends Mock[SsmContacts] {
  object UpdateContact
      extends Effect[
        UpdateContactRequest,
        AwsError,
        zio.aws.ssmcontacts.model.UpdateContactResponse.ReadOnly
      ]
  object GetContactPolicy
      extends Effect[GetContactPolicyRequest, AwsError, ReadOnly]
  object ActivateContactChannel
      extends Effect[
        ActivateContactChannelRequest,
        AwsError,
        zio.aws.ssmcontacts.model.ActivateContactChannelResponse.ReadOnly
      ]
  object ListPagesByContact
      extends Stream[
        ListPagesByContactRequest,
        AwsError,
        zio.aws.ssmcontacts.model.Page.ReadOnly
      ]
  object ListPagesByContactPaginated
      extends Effect[
        ListPagesByContactRequest,
        AwsError,
        zio.aws.ssmcontacts.model.ListPagesByContactResponse.ReadOnly
      ]
  object DeleteContactChannel
      extends Effect[
        DeleteContactChannelRequest,
        AwsError,
        zio.aws.ssmcontacts.model.DeleteContactChannelResponse.ReadOnly
      ]
  object CreateContactChannel
      extends Effect[
        CreateContactChannelRequest,
        AwsError,
        zio.aws.ssmcontacts.model.CreateContactChannelResponse.ReadOnly
      ]
  object DeleteContact
      extends Effect[
        DeleteContactRequest,
        AwsError,
        zio.aws.ssmcontacts.model.DeleteContactResponse.ReadOnly
      ]
  object CreateContact
      extends Effect[
        CreateContactRequest,
        AwsError,
        zio.aws.ssmcontacts.model.CreateContactResponse.ReadOnly
      ]
  object ListEngagements
      extends Stream[
        ListEngagementsRequest,
        AwsError,
        zio.aws.ssmcontacts.model.Engagement.ReadOnly
      ]
  object ListEngagementsPaginated
      extends Effect[
        ListEngagementsRequest,
        AwsError,
        zio.aws.ssmcontacts.model.ListEngagementsResponse.ReadOnly
      ]
  object ListPagesByEngagement
      extends Stream[
        ListPagesByEngagementRequest,
        AwsError,
        zio.aws.ssmcontacts.model.Page.ReadOnly
      ]
  object ListPagesByEngagementPaginated
      extends Effect[
        ListPagesByEngagementRequest,
        AwsError,
        zio.aws.ssmcontacts.model.ListPagesByEngagementResponse.ReadOnly
      ]
  object DeactivateContactChannel
      extends Effect[
        DeactivateContactChannelRequest,
        AwsError,
        zio.aws.ssmcontacts.model.DeactivateContactChannelResponse.ReadOnly
      ]
  object DescribePage
      extends Effect[
        DescribePageRequest,
        AwsError,
        zio.aws.ssmcontacts.model.DescribePageResponse.ReadOnly
      ]
  object SendActivationCode
      extends Effect[
        SendActivationCodeRequest,
        AwsError,
        zio.aws.ssmcontacts.model.SendActivationCodeResponse.ReadOnly
      ]
  object StartEngagement
      extends Effect[
        StartEngagementRequest,
        AwsError,
        zio.aws.ssmcontacts.model.StartEngagementResponse.ReadOnly
      ]
  object AcceptPage
      extends Effect[
        AcceptPageRequest,
        AwsError,
        zio.aws.ssmcontacts.model.AcceptPageResponse.ReadOnly
      ]
  object GetContactChannel
      extends Effect[
        GetContactChannelRequest,
        AwsError,
        zio.aws.ssmcontacts.model.GetContactChannelResponse.ReadOnly
      ]
  object UntagResource
      extends Effect[
        UntagResourceRequest,
        AwsError,
        zio.aws.ssmcontacts.model.UntagResourceResponse.ReadOnly
      ]
  object ListPageReceipts
      extends Stream[
        ListPageReceiptsRequest,
        AwsError,
        zio.aws.ssmcontacts.model.Receipt.ReadOnly
      ]
  object ListPageReceiptsPaginated
      extends Effect[
        ListPageReceiptsRequest,
        AwsError,
        zio.aws.ssmcontacts.model.ListPageReceiptsResponse.ReadOnly
      ]
  object ListTagsForResource
      extends Effect[
        ListTagsForResourceRequest,
        AwsError,
        zio.aws.ssmcontacts.model.ListTagsForResourceResponse.ReadOnly
      ]
  object TagResource
      extends Effect[
        TagResourceRequest,
        AwsError,
        zio.aws.ssmcontacts.model.TagResourceResponse.ReadOnly
      ]
  object DescribeEngagement
      extends Effect[
        DescribeEngagementRequest,
        AwsError,
        zio.aws.ssmcontacts.model.DescribeEngagementResponse.ReadOnly
      ]
  object GetContact
      extends Effect[
        GetContactRequest,
        AwsError,
        zio.aws.ssmcontacts.model.GetContactResponse.ReadOnly
      ]
  object ListContacts
      extends Stream[
        ListContactsRequest,
        AwsError,
        zio.aws.ssmcontacts.model.Contact.ReadOnly
      ]
  object ListContactsPaginated
      extends Effect[
        ListContactsRequest,
        AwsError,
        zio.aws.ssmcontacts.model.ListContactsResponse.ReadOnly
      ]
  object PutContactPolicy
      extends Effect[
        PutContactPolicyRequest,
        AwsError,
        zio.aws.ssmcontacts.model.PutContactPolicyResponse.ReadOnly
      ]
  object UpdateContactChannel
      extends Effect[
        UpdateContactChannelRequest,
        AwsError,
        zio.aws.ssmcontacts.model.UpdateContactChannelResponse.ReadOnly
      ]
  object ListContactChannels
      extends Stream[
        ListContactChannelsRequest,
        AwsError,
        zio.aws.ssmcontacts.model.ContactChannel.ReadOnly
      ]
  object ListContactChannelsPaginated
      extends Effect[
        ListContactChannelsRequest,
        AwsError,
        zio.aws.ssmcontacts.model.ListContactChannelsResponse.ReadOnly
      ]
  object StopEngagement
      extends Effect[
        StopEngagementRequest,
        AwsError,
        zio.aws.ssmcontacts.model.StopEngagementResponse.ReadOnly
      ]
  val compose: URLayer[Proxy, SsmContacts] = zio.ZLayer {
    zio.ZIO.service[Proxy].flatMap { proxy =>
      withRuntime[Proxy, SsmContacts] { rts =>
        zio.ZIO.succeed {
          new SsmContacts {
            val api: SsmContactsAsyncClient = null
            def withAspect[R1](
                newAspect: AwsCallAspect[R1],
                r: ZEnvironment[R1]
            ): SsmContacts = this
            def updateContact(request: UpdateContactRequest): IO[
              AwsError,
              zio.aws.ssmcontacts.model.UpdateContactResponse.ReadOnly
            ] = proxy(UpdateContact, request)
            def getContactPolicy(
                request: GetContactPolicyRequest
            ): IO[AwsError, ReadOnly] = proxy(GetContactPolicy, request)
            def activateContactChannel(
                request: ActivateContactChannelRequest
            ): IO[
              AwsError,
              zio.aws.ssmcontacts.model.ActivateContactChannelResponse.ReadOnly
            ] = proxy(ActivateContactChannel, request)
            def listPagesByContact(
                request: ListPagesByContactRequest
            ): ZStream[Any, AwsError, zio.aws.ssmcontacts.model.Page.ReadOnly] =
              zio.Unsafe.unsafe { implicit u =>
                rts.unsafe
                  .run {
                    proxy(ListPagesByContact, request)
                  }
                  .getOrThrowFiberFailure()
              }
            def listPagesByContactPaginated(
                request: ListPagesByContactRequest
            ): IO[
              AwsError,
              zio.aws.ssmcontacts.model.ListPagesByContactResponse.ReadOnly
            ] = proxy(ListPagesByContactPaginated, request)
            def deleteContactChannel(request: DeleteContactChannelRequest): IO[
              AwsError,
              zio.aws.ssmcontacts.model.DeleteContactChannelResponse.ReadOnly
            ] = proxy(DeleteContactChannel, request)
            def createContactChannel(request: CreateContactChannelRequest): IO[
              AwsError,
              zio.aws.ssmcontacts.model.CreateContactChannelResponse.ReadOnly
            ] = proxy(CreateContactChannel, request)
            def deleteContact(request: DeleteContactRequest): IO[
              AwsError,
              zio.aws.ssmcontacts.model.DeleteContactResponse.ReadOnly
            ] = proxy(DeleteContact, request)
            def createContact(request: CreateContactRequest): IO[
              AwsError,
              zio.aws.ssmcontacts.model.CreateContactResponse.ReadOnly
            ] = proxy(CreateContact, request)
            def listEngagements(request: ListEngagementsRequest): ZStream[
              Any,
              AwsError,
              zio.aws.ssmcontacts.model.Engagement.ReadOnly
            ] = zio.Unsafe.unsafe { implicit u =>
              rts.unsafe
                .run {
                  proxy(ListEngagements, request)
                }
                .getOrThrowFiberFailure()
            }
            def listEngagementsPaginated(request: ListEngagementsRequest): IO[
              AwsError,
              zio.aws.ssmcontacts.model.ListEngagementsResponse.ReadOnly
            ] = proxy(ListEngagementsPaginated, request)
            def listPagesByEngagement(
                request: ListPagesByEngagementRequest
            ): ZStream[Any, AwsError, zio.aws.ssmcontacts.model.Page.ReadOnly] =
              zio.Unsafe.unsafe { implicit u =>
                rts.unsafe
                  .run {
                    proxy(ListPagesByEngagement, request)
                  }
                  .getOrThrowFiberFailure()
              }
            def listPagesByEngagementPaginated(
                request: ListPagesByEngagementRequest
            ): IO[
              AwsError,
              zio.aws.ssmcontacts.model.ListPagesByEngagementResponse.ReadOnly
            ] = proxy(ListPagesByEngagementPaginated, request)
            def deactivateContactChannel(
                request: DeactivateContactChannelRequest
            ): IO[
              AwsError,
              zio.aws.ssmcontacts.model.DeactivateContactChannelResponse.ReadOnly
            ] = proxy(DeactivateContactChannel, request)
            def describePage(request: DescribePageRequest): IO[
              AwsError,
              zio.aws.ssmcontacts.model.DescribePageResponse.ReadOnly
            ] = proxy(DescribePage, request)
            def sendActivationCode(request: SendActivationCodeRequest): IO[
              AwsError,
              zio.aws.ssmcontacts.model.SendActivationCodeResponse.ReadOnly
            ] = proxy(SendActivationCode, request)
            def startEngagement(request: StartEngagementRequest): IO[
              AwsError,
              zio.aws.ssmcontacts.model.StartEngagementResponse.ReadOnly
            ] = proxy(StartEngagement, request)
            def acceptPage(request: AcceptPageRequest): IO[
              AwsError,
              zio.aws.ssmcontacts.model.AcceptPageResponse.ReadOnly
            ] = proxy(AcceptPage, request)
            def getContactChannel(request: GetContactChannelRequest): IO[
              AwsError,
              zio.aws.ssmcontacts.model.GetContactChannelResponse.ReadOnly
            ] = proxy(GetContactChannel, request)
            def untagResource(request: UntagResourceRequest): IO[
              AwsError,
              zio.aws.ssmcontacts.model.UntagResourceResponse.ReadOnly
            ] = proxy(UntagResource, request)
            def listPageReceipts(request: ListPageReceiptsRequest): ZStream[
              Any,
              AwsError,
              zio.aws.ssmcontacts.model.Receipt.ReadOnly
            ] = zio.Unsafe.unsafe { implicit u =>
              rts.unsafe
                .run {
                  proxy(ListPageReceipts, request)
                }
                .getOrThrowFiberFailure()
            }
            def listPageReceiptsPaginated(request: ListPageReceiptsRequest): IO[
              AwsError,
              zio.aws.ssmcontacts.model.ListPageReceiptsResponse.ReadOnly
            ] = proxy(ListPageReceiptsPaginated, request)
            def listTagsForResource(request: ListTagsForResourceRequest): IO[
              AwsError,
              zio.aws.ssmcontacts.model.ListTagsForResourceResponse.ReadOnly
            ] = proxy(ListTagsForResource, request)
            def tagResource(request: TagResourceRequest): IO[
              AwsError,
              zio.aws.ssmcontacts.model.TagResourceResponse.ReadOnly
            ] = proxy(TagResource, request)
            def describeEngagement(request: DescribeEngagementRequest): IO[
              AwsError,
              zio.aws.ssmcontacts.model.DescribeEngagementResponse.ReadOnly
            ] = proxy(DescribeEngagement, request)
            def getContact(request: GetContactRequest): IO[
              AwsError,
              zio.aws.ssmcontacts.model.GetContactResponse.ReadOnly
            ] = proxy(GetContact, request)
            def listContacts(request: ListContactsRequest): ZStream[
              Any,
              AwsError,
              zio.aws.ssmcontacts.model.Contact.ReadOnly
            ] = zio.Unsafe.unsafe { implicit u =>
              rts.unsafe
                .run {
                  proxy(ListContacts, request)
                }
                .getOrThrowFiberFailure()
            }
            def listContactsPaginated(request: ListContactsRequest): IO[
              AwsError,
              zio.aws.ssmcontacts.model.ListContactsResponse.ReadOnly
            ] = proxy(ListContactsPaginated, request)
            def putContactPolicy(request: PutContactPolicyRequest): IO[
              AwsError,
              zio.aws.ssmcontacts.model.PutContactPolicyResponse.ReadOnly
            ] = proxy(PutContactPolicy, request)
            def updateContactChannel(request: UpdateContactChannelRequest): IO[
              AwsError,
              zio.aws.ssmcontacts.model.UpdateContactChannelResponse.ReadOnly
            ] = proxy(UpdateContactChannel, request)
            def listContactChannels(
                request: ListContactChannelsRequest
            ): ZStream[
              Any,
              AwsError,
              zio.aws.ssmcontacts.model.ContactChannel.ReadOnly
            ] = zio.Unsafe.unsafe { implicit u =>
              rts.unsafe
                .run {
                  proxy(ListContactChannels, request)
                }
                .getOrThrowFiberFailure()
            }
            def listContactChannelsPaginated(
                request: ListContactChannelsRequest
            ): IO[
              AwsError,
              zio.aws.ssmcontacts.model.ListContactChannelsResponse.ReadOnly
            ] = proxy(ListContactChannelsPaginated, request)
            def stopEngagement(request: StopEngagementRequest): IO[
              AwsError,
              zio.aws.ssmcontacts.model.StopEngagementResponse.ReadOnly
            ] = proxy(StopEngagement, request)
          }
        }
      }
    }
  }
}
