package zio.aws.ssmcontacts.model
import scala.jdk.CollectionConverters._
sealed trait AcceptCodeValidation {
  def unwrap
      : software.amazon.awssdk.services.ssmcontacts.model.AcceptCodeValidation
}
object AcceptCodeValidation {
  def wrap(
      value: software.amazon.awssdk.services.ssmcontacts.model.AcceptCodeValidation
  ): zio.aws.ssmcontacts.model.AcceptCodeValidation = value match {
    case software.amazon.awssdk.services.ssmcontacts.model.AcceptCodeValidation.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.ssmcontacts.model.AcceptCodeValidation.IGNORE =>
      val r = IGNORE
      r
    case software.amazon.awssdk.services.ssmcontacts.model.AcceptCodeValidation.ENFORCE =>
      val r = ENFORCE
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.ssmcontacts.model.AcceptCodeValidation {
    override def unwrap
        : software.amazon.awssdk.services.ssmcontacts.model.AcceptCodeValidation =
      software.amazon.awssdk.services.ssmcontacts.model.AcceptCodeValidation.UNKNOWN_TO_SDK_VERSION
  }
  case object IGNORE extends zio.aws.ssmcontacts.model.AcceptCodeValidation {
    override def unwrap
        : software.amazon.awssdk.services.ssmcontacts.model.AcceptCodeValidation =
      software.amazon.awssdk.services.ssmcontacts.model.AcceptCodeValidation.IGNORE
  }
  case object ENFORCE extends zio.aws.ssmcontacts.model.AcceptCodeValidation {
    override def unwrap
        : software.amazon.awssdk.services.ssmcontacts.model.AcceptCodeValidation =
      software.amazon.awssdk.services.ssmcontacts.model.AcceptCodeValidation.ENFORCE
  }
}
