package zio.aws.ssmcontacts.model
import zio.aws.ssmcontacts.model.primitives.{
  AcceptCode,
  ReceiptInfo,
  SsmContactsArn
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class AcceptPageRequest(
    pageId: SsmContactsArn,
    contactChannelId: Optional[SsmContactsArn] = Optional.Absent,
    acceptType: zio.aws.ssmcontacts.model.AcceptType,
    note: Optional[ReceiptInfo] = Optional.Absent,
    acceptCode: AcceptCode,
    acceptCodeValidation: Optional[
      zio.aws.ssmcontacts.model.AcceptCodeValidation
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ssmcontacts.model.AcceptPageRequest = {
    import AcceptPageRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ssmcontacts.model.AcceptPageRequest
      .builder()
      .pageId(SsmContactsArn.unwrap(pageId): java.lang.String)
      .optionallyWith(
        contactChannelId.map(value =>
          SsmContactsArn.unwrap(value): java.lang.String
        )
      )(_.contactChannelId)
      .acceptType(acceptType.unwrap)
      .optionallyWith(
        note.map(value => ReceiptInfo.unwrap(value): java.lang.String)
      )(_.note)
      .acceptCode(AcceptCode.unwrap(acceptCode): java.lang.String)
      .optionallyWith(acceptCodeValidation.map(value => value.unwrap))(
        _.acceptCodeValidation
      )
      .build()
  }
  def asReadOnly: zio.aws.ssmcontacts.model.AcceptPageRequest.ReadOnly =
    zio.aws.ssmcontacts.model.AcceptPageRequest.wrap(buildAwsValue())
}
object AcceptPageRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ssmcontacts.model.AcceptPageRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ssmcontacts.model.AcceptPageRequest =
      zio.aws.ssmcontacts.model.AcceptPageRequest(
        pageId,
        contactChannelId.map(value => value),
        acceptType,
        note.map(value => value),
        acceptCode,
        acceptCodeValidation.map(value => value)
      )
    def pageId: SsmContactsArn
    def contactChannelId: Optional[SsmContactsArn]
    def acceptType: zio.aws.ssmcontacts.model.AcceptType
    def note: Optional[ReceiptInfo]
    def acceptCode: AcceptCode
    def acceptCodeValidation
        : Optional[zio.aws.ssmcontacts.model.AcceptCodeValidation]
    def getPageId: ZIO[Any, Nothing, SsmContactsArn] = ZIO.succeed(pageId)
    def getContactChannelId: ZIO[Any, AwsError, SsmContactsArn] =
      AwsError.unwrapOptionField("contactChannelId", contactChannelId)
    def getAcceptType: ZIO[Any, Nothing, zio.aws.ssmcontacts.model.AcceptType] =
      ZIO.succeed(acceptType)
    def getNote: ZIO[Any, AwsError, ReceiptInfo] =
      AwsError.unwrapOptionField("note", note)
    def getAcceptCode: ZIO[Any, Nothing, AcceptCode] = ZIO.succeed(acceptCode)
    def getAcceptCodeValidation
        : ZIO[Any, AwsError, zio.aws.ssmcontacts.model.AcceptCodeValidation] =
      AwsError.unwrapOptionField("acceptCodeValidation", acceptCodeValidation)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ssmcontacts.model.AcceptPageRequest
  ) extends zio.aws.ssmcontacts.model.AcceptPageRequest.ReadOnly {
    override val pageId: SsmContactsArn =
      zio.aws.ssmcontacts.model.primitives.SsmContactsArn(impl.pageId())
    override val contactChannelId: Optional[SsmContactsArn] =
      zio.aws.core.internal
        .optionalFromNullable(impl.contactChannelId())
        .map(value =>
          zio.aws.ssmcontacts.model.primitives.SsmContactsArn(value)
        )
    override val acceptType: zio.aws.ssmcontacts.model.AcceptType =
      zio.aws.ssmcontacts.model.AcceptType.wrap(impl.acceptType())
    override val note: Optional[ReceiptInfo] = zio.aws.core.internal
      .optionalFromNullable(impl.note())
      .map(value => zio.aws.ssmcontacts.model.primitives.ReceiptInfo(value))
    override val acceptCode: AcceptCode =
      zio.aws.ssmcontacts.model.primitives.AcceptCode(impl.acceptCode())
    override val acceptCodeValidation
        : Optional[zio.aws.ssmcontacts.model.AcceptCodeValidation] =
      zio.aws.core.internal
        .optionalFromNullable(impl.acceptCodeValidation())
        .map(value =>
          zio.aws.ssmcontacts.model.AcceptCodeValidation.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ssmcontacts.model.AcceptPageRequest
  ): zio.aws.ssmcontacts.model.AcceptPageRequest.ReadOnly = new Wrapper(impl)
}
