package zio.aws.ssmcontacts.model
import scala.jdk.CollectionConverters._
sealed trait AcceptType {
  def unwrap: software.amazon.awssdk.services.ssmcontacts.model.AcceptType
}
object AcceptType {
  def wrap(
      value: software.amazon.awssdk.services.ssmcontacts.model.AcceptType
  ): zio.aws.ssmcontacts.model.AcceptType = value match {
    case software.amazon.awssdk.services.ssmcontacts.model.AcceptType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.ssmcontacts.model.AcceptType.DELIVERED =>
      val r = DELIVERED
      r
    case software.amazon.awssdk.services.ssmcontacts.model.AcceptType.READ =>
      val r = READ
      r
  }
  case object unknownToSdkVersion extends zio.aws.ssmcontacts.model.AcceptType {
    override def unwrap
        : software.amazon.awssdk.services.ssmcontacts.model.AcceptType =
      software.amazon.awssdk.services.ssmcontacts.model.AcceptType.UNKNOWN_TO_SDK_VERSION
  }
  case object DELIVERED extends zio.aws.ssmcontacts.model.AcceptType {
    override def unwrap
        : software.amazon.awssdk.services.ssmcontacts.model.AcceptType =
      software.amazon.awssdk.services.ssmcontacts.model.AcceptType.DELIVERED
  }
  case object READ extends zio.aws.ssmcontacts.model.AcceptType {
    override def unwrap
        : software.amazon.awssdk.services.ssmcontacts.model.AcceptType =
      software.amazon.awssdk.services.ssmcontacts.model.AcceptType.READ
  }
}
