package zio.aws.ssmcontacts.model
import zio.aws.ssmcontacts.model.primitives.{ActivationCode, SsmContactsArn}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class ActivateContactChannelRequest(
    contactChannelId: SsmContactsArn,
    activationCode: ActivationCode
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ssmcontacts.model.ActivateContactChannelRequest = {
    import ActivateContactChannelRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ssmcontacts.model.ActivateContactChannelRequest
      .builder()
      .contactChannelId(
        SsmContactsArn.unwrap(contactChannelId): java.lang.String
      )
      .activationCode(ActivationCode.unwrap(activationCode): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.ssmcontacts.model.ActivateContactChannelRequest.ReadOnly =
    zio.aws.ssmcontacts.model.ActivateContactChannelRequest
      .wrap(buildAwsValue())
}
object ActivateContactChannelRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ssmcontacts.model.ActivateContactChannelRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ssmcontacts.model.ActivateContactChannelRequest =
      zio.aws.ssmcontacts.model
        .ActivateContactChannelRequest(contactChannelId, activationCode)
    def contactChannelId: SsmContactsArn
    def activationCode: ActivationCode
    def getContactChannelId: ZIO[Any, Nothing, SsmContactsArn] =
      ZIO.succeed(contactChannelId)
    def getActivationCode: ZIO[Any, Nothing, ActivationCode] =
      ZIO.succeed(activationCode)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ssmcontacts.model.ActivateContactChannelRequest
  ) extends zio.aws.ssmcontacts.model.ActivateContactChannelRequest.ReadOnly {
    override val contactChannelId: SsmContactsArn =
      zio.aws.ssmcontacts.model.primitives
        .SsmContactsArn(impl.contactChannelId())
    override val activationCode: ActivationCode =
      zio.aws.ssmcontacts.model.primitives.ActivationCode(impl.activationCode())
  }
  def wrap(
      impl: software.amazon.awssdk.services.ssmcontacts.model.ActivateContactChannelRequest
  ): zio.aws.ssmcontacts.model.ActivateContactChannelRequest.ReadOnly =
    new Wrapper(impl)
}
