package zio.aws.ssmcontacts.model
import scala.jdk.CollectionConverters._
sealed trait ActivationStatus {
  def unwrap: software.amazon.awssdk.services.ssmcontacts.model.ActivationStatus
}
object ActivationStatus {
  def wrap(
      value: software.amazon.awssdk.services.ssmcontacts.model.ActivationStatus
  ): zio.aws.ssmcontacts.model.ActivationStatus = value match {
    case software.amazon.awssdk.services.ssmcontacts.model.ActivationStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.ssmcontacts.model.ActivationStatus.ACTIVATED =>
      val r = ACTIVATED
      r
    case software.amazon.awssdk.services.ssmcontacts.model.ActivationStatus.NOT_ACTIVATED =>
      val r = NOT_ACTIVATED
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.ssmcontacts.model.ActivationStatus {
    override def unwrap
        : software.amazon.awssdk.services.ssmcontacts.model.ActivationStatus =
      software.amazon.awssdk.services.ssmcontacts.model.ActivationStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object ACTIVATED extends zio.aws.ssmcontacts.model.ActivationStatus {
    override def unwrap
        : software.amazon.awssdk.services.ssmcontacts.model.ActivationStatus =
      software.amazon.awssdk.services.ssmcontacts.model.ActivationStatus.ACTIVATED
  }
  case object NOT_ACTIVATED extends zio.aws.ssmcontacts.model.ActivationStatus {
    override def unwrap
        : software.amazon.awssdk.services.ssmcontacts.model.ActivationStatus =
      software.amazon.awssdk.services.ssmcontacts.model.ActivationStatus.NOT_ACTIVATED
  }
}
