package zio.aws.ssmcontacts.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.ssmcontacts.model.primitives.{
  RetryIntervalInMinutes,
  SsmContactsArn
}
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class ChannelTargetInfo(
    contactChannelId: SsmContactsArn,
    retryIntervalInMinutes: Optional[RetryIntervalInMinutes] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ssmcontacts.model.ChannelTargetInfo = {
    import ChannelTargetInfo.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ssmcontacts.model.ChannelTargetInfo
      .builder()
      .contactChannelId(
        SsmContactsArn.unwrap(contactChannelId): java.lang.String
      )
      .optionallyWith(
        retryIntervalInMinutes.map(value =>
          RetryIntervalInMinutes.unwrap(value): Integer
        )
      )(_.retryIntervalInMinutes)
      .build()
  }
  def asReadOnly: zio.aws.ssmcontacts.model.ChannelTargetInfo.ReadOnly =
    zio.aws.ssmcontacts.model.ChannelTargetInfo.wrap(buildAwsValue())
}
object ChannelTargetInfo {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ssmcontacts.model.ChannelTargetInfo
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ssmcontacts.model.ChannelTargetInfo =
      zio.aws.ssmcontacts.model.ChannelTargetInfo(
        contactChannelId,
        retryIntervalInMinutes.map(value => value)
      )
    def contactChannelId: SsmContactsArn
    def retryIntervalInMinutes: Optional[RetryIntervalInMinutes]
    def getContactChannelId: ZIO[Any, Nothing, SsmContactsArn] =
      ZIO.succeed(contactChannelId)
    def getRetryIntervalInMinutes: ZIO[Any, AwsError, RetryIntervalInMinutes] =
      AwsError.unwrapOptionField(
        "retryIntervalInMinutes",
        retryIntervalInMinutes
      )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ssmcontacts.model.ChannelTargetInfo
  ) extends zio.aws.ssmcontacts.model.ChannelTargetInfo.ReadOnly {
    override val contactChannelId: SsmContactsArn =
      zio.aws.ssmcontacts.model.primitives
        .SsmContactsArn(impl.contactChannelId())
    override val retryIntervalInMinutes: Optional[RetryIntervalInMinutes] =
      zio.aws.core.internal
        .optionalFromNullable(impl.retryIntervalInMinutes())
        .map(value =>
          zio.aws.ssmcontacts.model.primitives.RetryIntervalInMinutes(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ssmcontacts.model.ChannelTargetInfo
  ): zio.aws.ssmcontacts.model.ChannelTargetInfo.ReadOnly = new Wrapper(impl)
}
