package zio.aws.ssmcontacts.model
import scala.jdk.CollectionConverters._
sealed trait ChannelType {
  def unwrap: software.amazon.awssdk.services.ssmcontacts.model.ChannelType
}
object ChannelType {
  def wrap(
      value: software.amazon.awssdk.services.ssmcontacts.model.ChannelType
  ): zio.aws.ssmcontacts.model.ChannelType = value match {
    case software.amazon.awssdk.services.ssmcontacts.model.ChannelType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.ssmcontacts.model.ChannelType.SMS =>
      val r = SMS
      r
    case software.amazon.awssdk.services.ssmcontacts.model.ChannelType.VOICE =>
      val r = VOICE
      r
    case software.amazon.awssdk.services.ssmcontacts.model.ChannelType.EMAIL =>
      val r = EMAIL
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.ssmcontacts.model.ChannelType {
    override def unwrap
        : software.amazon.awssdk.services.ssmcontacts.model.ChannelType =
      software.amazon.awssdk.services.ssmcontacts.model.ChannelType.UNKNOWN_TO_SDK_VERSION
  }
  case object SMS extends zio.aws.ssmcontacts.model.ChannelType {
    override def unwrap
        : software.amazon.awssdk.services.ssmcontacts.model.ChannelType =
      software.amazon.awssdk.services.ssmcontacts.model.ChannelType.SMS
  }
  case object VOICE extends zio.aws.ssmcontacts.model.ChannelType {
    override def unwrap
        : software.amazon.awssdk.services.ssmcontacts.model.ChannelType =
      software.amazon.awssdk.services.ssmcontacts.model.ChannelType.VOICE
  }
  case object EMAIL extends zio.aws.ssmcontacts.model.ChannelType {
    override def unwrap
        : software.amazon.awssdk.services.ssmcontacts.model.ChannelType =
      software.amazon.awssdk.services.ssmcontacts.model.ChannelType.EMAIL
  }
}
