package zio.aws.ssmcontacts.model
import zio.aws.ssmcontacts.model.primitives.{
  ContactName,
  ContactAlias,
  SsmContactsArn
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class Contact(
    contactArn: SsmContactsArn,
    alias: ContactAlias,
    displayName: Optional[ContactName] = Optional.Absent,
    `type`: zio.aws.ssmcontacts.model.ContactType
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ssmcontacts.model.Contact = {
    import Contact.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ssmcontacts.model.Contact
      .builder()
      .contactArn(SsmContactsArn.unwrap(contactArn): java.lang.String)
      .alias(ContactAlias.unwrap(alias): java.lang.String)
      .optionallyWith(
        displayName.map(value => ContactName.unwrap(value): java.lang.String)
      )(_.displayName)
      .`type`(`type`.unwrap)
      .build()
  }
  def asReadOnly: zio.aws.ssmcontacts.model.Contact.ReadOnly =
    zio.aws.ssmcontacts.model.Contact.wrap(buildAwsValue())
}
object Contact {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ssmcontacts.model.Contact
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ssmcontacts.model.Contact =
      zio.aws.ssmcontacts.model.Contact(
        contactArn,
        alias,
        displayName.map(value => value),
        `type`
      )
    def contactArn: SsmContactsArn
    def alias: ContactAlias
    def displayName: Optional[ContactName]
    def `type`: zio.aws.ssmcontacts.model.ContactType
    def getContactArn: ZIO[Any, Nothing, SsmContactsArn] =
      ZIO.succeed(contactArn)
    def getAlias: ZIO[Any, Nothing, ContactAlias] = ZIO.succeed(alias)
    def getDisplayName: ZIO[Any, AwsError, ContactName] =
      AwsError.unwrapOptionField("displayName", displayName)
    def getType: ZIO[Any, Nothing, zio.aws.ssmcontacts.model.ContactType] =
      ZIO.succeed(`type`)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ssmcontacts.model.Contact
  ) extends zio.aws.ssmcontacts.model.Contact.ReadOnly {
    override val contactArn: SsmContactsArn =
      zio.aws.ssmcontacts.model.primitives.SsmContactsArn(impl.contactArn())
    override val alias: ContactAlias =
      zio.aws.ssmcontacts.model.primitives.ContactAlias(impl.alias())
    override val displayName: Optional[ContactName] = zio.aws.core.internal
      .optionalFromNullable(impl.displayName())
      .map(value => zio.aws.ssmcontacts.model.primitives.ContactName(value))
    override val `type`: zio.aws.ssmcontacts.model.ContactType =
      zio.aws.ssmcontacts.model.ContactType.wrap(impl.`type`())
  }
  def wrap(
      impl: software.amazon.awssdk.services.ssmcontacts.model.Contact
  ): zio.aws.ssmcontacts.model.Contact.ReadOnly = new Wrapper(impl)
}
