package zio.aws.ssmcontacts.model
import zio.aws.ssmcontacts.model.primitives.{ChannelName, SsmContactsArn}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ContactChannel(
    contactChannelArn: SsmContactsArn,
    contactArn: SsmContactsArn,
    name: ChannelName,
    `type`: Optional[zio.aws.ssmcontacts.model.ChannelType] = Optional.Absent,
    deliveryAddress: zio.aws.ssmcontacts.model.ContactChannelAddress,
    activationStatus: zio.aws.ssmcontacts.model.ActivationStatus
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ssmcontacts.model.ContactChannel = {
    import ContactChannel.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ssmcontacts.model.ContactChannel
      .builder()
      .contactChannelArn(
        SsmContactsArn.unwrap(contactChannelArn): java.lang.String
      )
      .contactArn(SsmContactsArn.unwrap(contactArn): java.lang.String)
      .name(ChannelName.unwrap(name): java.lang.String)
      .optionallyWith(`type`.map(value => value.unwrap))(_.`type`)
      .deliveryAddress(deliveryAddress.buildAwsValue())
      .activationStatus(activationStatus.unwrap)
      .build()
  }
  def asReadOnly: zio.aws.ssmcontacts.model.ContactChannel.ReadOnly =
    zio.aws.ssmcontacts.model.ContactChannel.wrap(buildAwsValue())
}
object ContactChannel {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ssmcontacts.model.ContactChannel
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ssmcontacts.model.ContactChannel =
      zio.aws.ssmcontacts.model.ContactChannel(
        contactChannelArn,
        contactArn,
        name,
        `type`.map(value => value),
        deliveryAddress.asEditable,
        activationStatus
      )
    def contactChannelArn: SsmContactsArn
    def contactArn: SsmContactsArn
    def name: ChannelName
    def `type`: Optional[zio.aws.ssmcontacts.model.ChannelType]
    def deliveryAddress
        : zio.aws.ssmcontacts.model.ContactChannelAddress.ReadOnly
    def activationStatus: zio.aws.ssmcontacts.model.ActivationStatus
    def getContactChannelArn: ZIO[Any, Nothing, SsmContactsArn] =
      ZIO.succeed(contactChannelArn)
    def getContactArn: ZIO[Any, Nothing, SsmContactsArn] =
      ZIO.succeed(contactArn)
    def getName: ZIO[Any, Nothing, ChannelName] = ZIO.succeed(name)
    def getType: ZIO[Any, AwsError, zio.aws.ssmcontacts.model.ChannelType] =
      AwsError.unwrapOptionField("type", `type`)
    def getDeliveryAddress: ZIO[
      Any,
      Nothing,
      zio.aws.ssmcontacts.model.ContactChannelAddress.ReadOnly
    ] = ZIO.succeed(deliveryAddress)
    def getActivationStatus
        : ZIO[Any, Nothing, zio.aws.ssmcontacts.model.ActivationStatus] =
      ZIO.succeed(activationStatus)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ssmcontacts.model.ContactChannel
  ) extends zio.aws.ssmcontacts.model.ContactChannel.ReadOnly {
    override val contactChannelArn: SsmContactsArn =
      zio.aws.ssmcontacts.model.primitives
        .SsmContactsArn(impl.contactChannelArn())
    override val contactArn: SsmContactsArn =
      zio.aws.ssmcontacts.model.primitives.SsmContactsArn(impl.contactArn())
    override val name: ChannelName =
      zio.aws.ssmcontacts.model.primitives.ChannelName(impl.name())
    override val `type`: Optional[zio.aws.ssmcontacts.model.ChannelType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.`type`())
        .map(value => zio.aws.ssmcontacts.model.ChannelType.wrap(value))
    override val deliveryAddress
        : zio.aws.ssmcontacts.model.ContactChannelAddress.ReadOnly =
      zio.aws.ssmcontacts.model.ContactChannelAddress
        .wrap(impl.deliveryAddress())
    override val activationStatus: zio.aws.ssmcontacts.model.ActivationStatus =
      zio.aws.ssmcontacts.model.ActivationStatus.wrap(impl.activationStatus())
  }
  def wrap(
      impl: software.amazon.awssdk.services.ssmcontacts.model.ContactChannel
  ): zio.aws.ssmcontacts.model.ContactChannel.ReadOnly = new Wrapper(impl)
}
