package zio.aws.ssmcontacts.model
import zio.aws.ssmcontacts.model.primitives.SimpleAddress
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ContactChannelAddress(
    simpleAddress: Optional[SimpleAddress] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ssmcontacts.model.ContactChannelAddress = {
    import ContactChannelAddress.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ssmcontacts.model.ContactChannelAddress
      .builder()
      .optionallyWith(
        simpleAddress.map(value =>
          SimpleAddress.unwrap(value): java.lang.String
        )
      )(_.simpleAddress)
      .build()
  }
  def asReadOnly: zio.aws.ssmcontacts.model.ContactChannelAddress.ReadOnly =
    zio.aws.ssmcontacts.model.ContactChannelAddress.wrap(buildAwsValue())
}
object ContactChannelAddress {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ssmcontacts.model.ContactChannelAddress
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ssmcontacts.model.ContactChannelAddress =
      zio.aws.ssmcontacts.model
        .ContactChannelAddress(simpleAddress.map(value => value))
    def simpleAddress: Optional[SimpleAddress]
    def getSimpleAddress: ZIO[Any, AwsError, SimpleAddress] =
      AwsError.unwrapOptionField("simpleAddress", simpleAddress)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ssmcontacts.model.ContactChannelAddress
  ) extends zio.aws.ssmcontacts.model.ContactChannelAddress.ReadOnly {
    override val simpleAddress: Optional[SimpleAddress] = zio.aws.core.internal
      .optionalFromNullable(impl.simpleAddress())
      .map(value => zio.aws.ssmcontacts.model.primitives.SimpleAddress(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ssmcontacts.model.ContactChannelAddress
  ): zio.aws.ssmcontacts.model.ContactChannelAddress.ReadOnly = new Wrapper(
    impl
  )
}
