package zio.aws.ssmcontacts.model
import zio.aws.ssmcontacts.model.primitives.{IsEssential, SsmContactsArn}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ContactTargetInfo(
    contactId: Optional[SsmContactsArn] = Optional.Absent,
    isEssential: IsEssential
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ssmcontacts.model.ContactTargetInfo = {
    import ContactTargetInfo.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ssmcontacts.model.ContactTargetInfo
      .builder()
      .optionallyWith(
        contactId.map(value => SsmContactsArn.unwrap(value): java.lang.String)
      )(_.contactId)
      .isEssential(IsEssential.unwrap(isEssential): java.lang.Boolean)
      .build()
  }
  def asReadOnly: zio.aws.ssmcontacts.model.ContactTargetInfo.ReadOnly =
    zio.aws.ssmcontacts.model.ContactTargetInfo.wrap(buildAwsValue())
}
object ContactTargetInfo {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ssmcontacts.model.ContactTargetInfo
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ssmcontacts.model.ContactTargetInfo =
      zio.aws.ssmcontacts.model
        .ContactTargetInfo(contactId.map(value => value), isEssential)
    def contactId: Optional[SsmContactsArn]
    def isEssential: IsEssential
    def getContactId: ZIO[Any, AwsError, SsmContactsArn] =
      AwsError.unwrapOptionField("contactId", contactId)
    def getIsEssential: ZIO[Any, Nothing, IsEssential] =
      ZIO.succeed(isEssential)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ssmcontacts.model.ContactTargetInfo
  ) extends zio.aws.ssmcontacts.model.ContactTargetInfo.ReadOnly {
    override val contactId: Optional[SsmContactsArn] = zio.aws.core.internal
      .optionalFromNullable(impl.contactId())
      .map(value => zio.aws.ssmcontacts.model.primitives.SsmContactsArn(value))
    override val isEssential: IsEssential =
      zio.aws.ssmcontacts.model.primitives.IsEssential(impl.isEssential())
  }
  def wrap(
      impl: software.amazon.awssdk.services.ssmcontacts.model.ContactTargetInfo
  ): zio.aws.ssmcontacts.model.ContactTargetInfo.ReadOnly = new Wrapper(impl)
}
