package zio.aws.ssmcontacts.model
import scala.jdk.CollectionConverters._
sealed trait ContactType {
  def unwrap: software.amazon.awssdk.services.ssmcontacts.model.ContactType
}
object ContactType {
  def wrap(
      value: software.amazon.awssdk.services.ssmcontacts.model.ContactType
  ): zio.aws.ssmcontacts.model.ContactType = value match {
    case software.amazon.awssdk.services.ssmcontacts.model.ContactType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.ssmcontacts.model.ContactType.PERSONAL =>
      val r = PERSONAL
      r
    case software.amazon.awssdk.services.ssmcontacts.model.ContactType.ESCALATION =>
      val r = ESCALATION
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.ssmcontacts.model.ContactType {
    override def unwrap
        : software.amazon.awssdk.services.ssmcontacts.model.ContactType =
      software.amazon.awssdk.services.ssmcontacts.model.ContactType.UNKNOWN_TO_SDK_VERSION
  }
  case object PERSONAL extends zio.aws.ssmcontacts.model.ContactType {
    override def unwrap
        : software.amazon.awssdk.services.ssmcontacts.model.ContactType =
      software.amazon.awssdk.services.ssmcontacts.model.ContactType.PERSONAL
  }
  case object ESCALATION extends zio.aws.ssmcontacts.model.ContactType {
    override def unwrap
        : software.amazon.awssdk.services.ssmcontacts.model.ContactType =
      software.amazon.awssdk.services.ssmcontacts.model.ContactType.ESCALATION
  }
}
