package zio.aws.ssmcontacts.model
import zio.aws.ssmcontacts.model.primitives.{
  IdempotencyToken,
  DeferActivation,
  ChannelName,
  SsmContactsArn
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class CreateContactChannelRequest(
    contactId: SsmContactsArn,
    name: ChannelName,
    `type`: zio.aws.ssmcontacts.model.ChannelType,
    deliveryAddress: zio.aws.ssmcontacts.model.ContactChannelAddress,
    deferActivation: Optional[DeferActivation] = Optional.Absent,
    idempotencyToken: Optional[IdempotencyToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ssmcontacts.model.CreateContactChannelRequest = {
    import CreateContactChannelRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ssmcontacts.model.CreateContactChannelRequest
      .builder()
      .contactId(SsmContactsArn.unwrap(contactId): java.lang.String)
      .name(ChannelName.unwrap(name): java.lang.String)
      .`type`(`type`.unwrap)
      .deliveryAddress(deliveryAddress.buildAwsValue())
      .optionallyWith(
        deferActivation.map(value =>
          DeferActivation.unwrap(value): java.lang.Boolean
        )
      )(_.deferActivation)
      .optionallyWith(
        idempotencyToken.map(value =>
          IdempotencyToken.unwrap(value): java.lang.String
        )
      )(_.idempotencyToken)
      .build()
  }
  def asReadOnly
      : zio.aws.ssmcontacts.model.CreateContactChannelRequest.ReadOnly =
    zio.aws.ssmcontacts.model.CreateContactChannelRequest.wrap(buildAwsValue())
}
object CreateContactChannelRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ssmcontacts.model.CreateContactChannelRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ssmcontacts.model.CreateContactChannelRequest =
      zio.aws.ssmcontacts.model.CreateContactChannelRequest(
        contactId,
        name,
        `type`,
        deliveryAddress.asEditable,
        deferActivation.map(value => value),
        idempotencyToken.map(value => value)
      )
    def contactId: SsmContactsArn
    def name: ChannelName
    def `type`: zio.aws.ssmcontacts.model.ChannelType
    def deliveryAddress
        : zio.aws.ssmcontacts.model.ContactChannelAddress.ReadOnly
    def deferActivation: Optional[DeferActivation]
    def idempotencyToken: Optional[IdempotencyToken]
    def getContactId: ZIO[Any, Nothing, SsmContactsArn] = ZIO.succeed(contactId)
    def getName: ZIO[Any, Nothing, ChannelName] = ZIO.succeed(name)
    def getType: ZIO[Any, Nothing, zio.aws.ssmcontacts.model.ChannelType] =
      ZIO.succeed(`type`)
    def getDeliveryAddress: ZIO[
      Any,
      Nothing,
      zio.aws.ssmcontacts.model.ContactChannelAddress.ReadOnly
    ] = ZIO.succeed(deliveryAddress)
    def getDeferActivation: ZIO[Any, AwsError, DeferActivation] =
      AwsError.unwrapOptionField("deferActivation", deferActivation)
    def getIdempotencyToken: ZIO[Any, AwsError, IdempotencyToken] =
      AwsError.unwrapOptionField("idempotencyToken", idempotencyToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ssmcontacts.model.CreateContactChannelRequest
  ) extends zio.aws.ssmcontacts.model.CreateContactChannelRequest.ReadOnly {
    override val contactId: SsmContactsArn =
      zio.aws.ssmcontacts.model.primitives.SsmContactsArn(impl.contactId())
    override val name: ChannelName =
      zio.aws.ssmcontacts.model.primitives.ChannelName(impl.name())
    override val `type`: zio.aws.ssmcontacts.model.ChannelType =
      zio.aws.ssmcontacts.model.ChannelType.wrap(impl.`type`())
    override val deliveryAddress
        : zio.aws.ssmcontacts.model.ContactChannelAddress.ReadOnly =
      zio.aws.ssmcontacts.model.ContactChannelAddress
        .wrap(impl.deliveryAddress())
    override val deferActivation: Optional[DeferActivation] =
      zio.aws.core.internal
        .optionalFromNullable(impl.deferActivation())
        .map(value =>
          zio.aws.ssmcontacts.model.primitives.DeferActivation(value)
        )
    override val idempotencyToken: Optional[IdempotencyToken] =
      zio.aws.core.internal
        .optionalFromNullable(impl.idempotencyToken())
        .map(value =>
          zio.aws.ssmcontacts.model.primitives.IdempotencyToken(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ssmcontacts.model.CreateContactChannelRequest
  ): zio.aws.ssmcontacts.model.CreateContactChannelRequest.ReadOnly =
    new Wrapper(impl)
}
