package zio.aws.ssmcontacts.model
import zio.aws.ssmcontacts.model.primitives.SsmContactsArn
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class CreateContactChannelResponse(
    contactChannelArn: SsmContactsArn
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ssmcontacts.model.CreateContactChannelResponse = {
    import CreateContactChannelResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ssmcontacts.model.CreateContactChannelResponse
      .builder()
      .contactChannelArn(
        SsmContactsArn.unwrap(contactChannelArn): java.lang.String
      )
      .build()
  }
  def asReadOnly
      : zio.aws.ssmcontacts.model.CreateContactChannelResponse.ReadOnly =
    zio.aws.ssmcontacts.model.CreateContactChannelResponse.wrap(buildAwsValue())
}
object CreateContactChannelResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ssmcontacts.model.CreateContactChannelResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ssmcontacts.model.CreateContactChannelResponse =
      zio.aws.ssmcontacts.model.CreateContactChannelResponse(contactChannelArn)
    def contactChannelArn: SsmContactsArn
    def getContactChannelArn: ZIO[Any, Nothing, SsmContactsArn] =
      ZIO.succeed(contactChannelArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ssmcontacts.model.CreateContactChannelResponse
  ) extends zio.aws.ssmcontacts.model.CreateContactChannelResponse.ReadOnly {
    override val contactChannelArn: SsmContactsArn =
      zio.aws.ssmcontacts.model.primitives
        .SsmContactsArn(impl.contactChannelArn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.ssmcontacts.model.CreateContactChannelResponse
  ): zio.aws.ssmcontacts.model.CreateContactChannelResponse.ReadOnly =
    new Wrapper(impl)
}
