package zio.aws.ssmcontacts.model
import zio.aws.ssmcontacts.model.primitives.{
  IdempotencyToken,
  ContactName,
  ContactAlias
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class CreateContactRequest(
    alias: ContactAlias,
    displayName: Optional[ContactName] = Optional.Absent,
    `type`: zio.aws.ssmcontacts.model.ContactType,
    plan: zio.aws.ssmcontacts.model.Plan,
    tags: Optional[Iterable[zio.aws.ssmcontacts.model.Tag]] = Optional.Absent,
    idempotencyToken: Optional[IdempotencyToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ssmcontacts.model.CreateContactRequest = {
    import CreateContactRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ssmcontacts.model.CreateContactRequest
      .builder()
      .alias(ContactAlias.unwrap(alias): java.lang.String)
      .optionallyWith(
        displayName.map(value => ContactName.unwrap(value): java.lang.String)
      )(_.displayName)
      .`type`(`type`.unwrap)
      .plan(plan.buildAwsValue())
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .optionallyWith(
        idempotencyToken.map(value =>
          IdempotencyToken.unwrap(value): java.lang.String
        )
      )(_.idempotencyToken)
      .build()
  }
  def asReadOnly: zio.aws.ssmcontacts.model.CreateContactRequest.ReadOnly =
    zio.aws.ssmcontacts.model.CreateContactRequest.wrap(buildAwsValue())
}
object CreateContactRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ssmcontacts.model.CreateContactRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ssmcontacts.model.CreateContactRequest =
      zio.aws.ssmcontacts.model.CreateContactRequest(
        alias,
        displayName.map(value => value),
        `type`,
        plan.asEditable,
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        idempotencyToken.map(value => value)
      )
    def alias: ContactAlias
    def displayName: Optional[ContactName]
    def `type`: zio.aws.ssmcontacts.model.ContactType
    def plan: zio.aws.ssmcontacts.model.Plan.ReadOnly
    def tags: Optional[List[zio.aws.ssmcontacts.model.Tag.ReadOnly]]
    def idempotencyToken: Optional[IdempotencyToken]
    def getAlias: ZIO[Any, Nothing, ContactAlias] = ZIO.succeed(alias)
    def getDisplayName: ZIO[Any, AwsError, ContactName] =
      AwsError.unwrapOptionField("displayName", displayName)
    def getType: ZIO[Any, Nothing, zio.aws.ssmcontacts.model.ContactType] =
      ZIO.succeed(`type`)
    def getPlan: ZIO[Any, Nothing, zio.aws.ssmcontacts.model.Plan.ReadOnly] =
      ZIO.succeed(plan)
    def getTags
        : ZIO[Any, AwsError, List[zio.aws.ssmcontacts.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
    def getIdempotencyToken: ZIO[Any, AwsError, IdempotencyToken] =
      AwsError.unwrapOptionField("idempotencyToken", idempotencyToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ssmcontacts.model.CreateContactRequest
  ) extends zio.aws.ssmcontacts.model.CreateContactRequest.ReadOnly {
    override val alias: ContactAlias =
      zio.aws.ssmcontacts.model.primitives.ContactAlias(impl.alias())
    override val displayName: Optional[ContactName] = zio.aws.core.internal
      .optionalFromNullable(impl.displayName())
      .map(value => zio.aws.ssmcontacts.model.primitives.ContactName(value))
    override val `type`: zio.aws.ssmcontacts.model.ContactType =
      zio.aws.ssmcontacts.model.ContactType.wrap(impl.`type`())
    override val plan: zio.aws.ssmcontacts.model.Plan.ReadOnly =
      zio.aws.ssmcontacts.model.Plan.wrap(impl.plan())
    override val tags: Optional[List[zio.aws.ssmcontacts.model.Tag.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ssmcontacts.model.Tag.wrap(item)
          }.toList
        )
    override val idempotencyToken: Optional[IdempotencyToken] =
      zio.aws.core.internal
        .optionalFromNullable(impl.idempotencyToken())
        .map(value =>
          zio.aws.ssmcontacts.model.primitives.IdempotencyToken(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ssmcontacts.model.CreateContactRequest
  ): zio.aws.ssmcontacts.model.CreateContactRequest.ReadOnly = new Wrapper(impl)
}
